/*
 **********************************************************************
 *  DLMS/COSEM components
 *
 *  i-cube software, 1966 Ayent, Switzerland
 *  infos@icube.ch
 *
 * (c) Copyright 2004-2016
 **********************************************************************
 */

package icube.demo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.*;

/**
 * Implements the TCP/IP communication resource.
 */
public class TCPChannel implements IChannel {

	private String host_;
	private int port_;
    private String ID_;
    private Socket socket_;

    /**
     * Instantiates a new instance of TCPChannel creating a tcp client.
     * 
     * @param host Host name.
     * @param port Port No.
     * 
     * @throws ChannelException Thrown for any detected error.
     */
    public TCPChannel(String host, int port) throws ChannelException {
    	this.host_ = host;
    	this.port_ = port;
    	
    	try {
			InetAddress _inetAdd = InetAddress.getByName(host);
		} catch (UnknownHostException e) {
			this.throwTCPException("TCPChannel() - UnknownHostException");
		}

	}
   
    @Override
	public InputStream getInputStream() throws IOException {
    	return this.socket_.getInputStream();
	}


	@Override
	public OutputStream getOutputStream() throws IOException {
    	return this.socket_.getOutputStream();
	}
    
	/* (non-Javadoc)
	 * @see icube.demo.io.IChannel#IsOpen()
	 */
	@Override
	public boolean isOpen() {
		return (this.socket_ != null) && (this.socket_.isConnected());
	}

	/* (non-Javadoc)
	 * @see icube.demo.io.IChannel#close()
	 */
	@Override
	public void close() throws ChannelException {
        try
        {
            this.socket_.close();
            this.socket_ = null;
            
        }
        catch (Exception e)
        {
            this.throwTCPException("close() - " + e.getMessage());
        }
	}


	/* (non-Javadoc)
	 * @see icube.demo.io.IChannel#getID()
	 */
	@Override
	public String getID() {
		if (this.socket_ != null){
			this.ID_= this.socket_.toString();
		} else {
			this.ID_ = this.host_ + ":" + Integer.toString(this.port_) + "not connected";
		}
		return this.ID_;
	}

	/* (non-Javadoc)
	 * @see icube.demo.io.IChannel#open(int)
	 */
	@Override
	public void open(int timeout) throws ChannelException {
        try
        {
        	this.socket_ = new Socket();
        	this.socket_.bind(null);
        	this.socket_.connect(new InetSocketAddress(this.host_, this.port_), timeout);
        	this.socket_.setSoTimeout(timeout);
        }
        catch (Exception e)
        {
            throwTCPException("open() - " + e.getMessage());
        }
	}

    private void throwTCPException(String message) throws ChannelException {
    	throw new ChannelException(message, ChannelException.ChannelExceptionKind.TCP);
    }
	    
}
