/*
 **********************************************************************
 *  DLMS/COSEM components
 *
 *  i-cube software, 1966 Ayent, Switzerland
 *  infos@icube.ch
 *
 * (c) Copyright 2004-2016
 **********************************************************************
 */

package icube.demo.io;

import java.io.IOException;

/**
 * This interface defines simple communication channel methods to
 * access metering devices.
 * </p>The library provides implementation for serial port and TCP/IP.
 */
public interface IChannel {

	java.io.InputStream getInputStream() throws IOException;
	java.io.OutputStream getOutputStream() throws IOException;
	
    /**
     * Returns the communication channel ID. (i.e. COM1, ...)
     * 
     * @return Channel ID.
     */
    String getID();
    
    /**
     * Returns the open status of the communication channel.
     * 
     * @return true if is open.
     */
    boolean isOpen();
    
    /**
     * Opens the communication channel.
     * 
     * @param timeout Default Timeout (in ms) to be used for all
     * read actions.
     * @throws ChannelException Thrown for any detected error.
     */
    void open(int timeout) throws ChannelException;
    
    /**
     * Closes the communication channel.
     * 
     * @throws ChannelException Thrown for any detected error.
     */
    void close() throws ChannelException;
    
}
