/*
 **********************************************************************
 *  DLMS/COSEM components
 *
 *  i-cube software, 1966 Ayent, Switzerland
 *  infos@icube.ch
 *
 * (c) Copyright 2004-2016
 **********************************************************************
 */

package icube.demo.io;

/**
 * Channel exception.
 */
public class ChannelException extends Exception {

	/**
	 * Enum ChannelExceptionKind.
	 * 
	 */
	public enum ChannelExceptionKind {
		/** Exception raised by COMChannel. */
		COM,
		/** Exception raised by TCPChannel. */
		TCP,
		/** Any other exception */
		Other
	}
	
	/**
	 * Exception kind.
	 */
	public ChannelExceptionKind kind;
	
	
	/**
	 * Instantiates a new ChannelException
	 * 
	 * @param message Exception description.
	 */
	public ChannelException(String message) {
		super(message);
		this.kind = ChannelExceptionKind.Other;
	}

	
	/**
	 * Instantiates a new ChannelException
	 * 
	 * @param message Exception description.
	 * @param kind Exception kind.
	 */
	public ChannelException(String message, ChannelExceptionKind kind) {
		super("ChannelException(" + kind.toString() + ") - " + message);
		this.kind = kind;
	}


	/**
	 * Instantiates a new ChannelException
	 * 
	 * @param e Exception.
	 */
	public ChannelException(ChannelException e) {
		super(e.getMessage());
		this.kind = e.kind;
	}


}
