/*
 **********************************************************************
 *  DLMS/COSEM components
 *
 *  i-cube software, 1966 Ayent, Switzerland
 *  infos@icube.ch
 *
 * (c) Copyright 2004-2016
 **********************************************************************
 */

package icube.demo.io;

/**
 * COMChannel parameters.
 */
public final class COMChannelParameters {

    /**
     * Port name (i.e. "COM1", "/dev/ttyS0").
     */
    public String PortName;
    
    /**
     * Baudrate.
     */
    public int Baud;
    
    /**
     * Instantiates a new COMChannelParameters.
     * <p>This constructor should be used if the meter doesn't echo it's input.
     * 
     * @param portName  Port name.
     * @param baud Baudrate.
     */
    public COMChannelParameters(String portName, int baud) {
        PortName = portName;
        Baud = baud;
    }
    
}
