 
//**********************************************************************
//  DLMS/COSEM components
//
//  i-cube, 1376 Goumoens-la-Ville, Switzerland
//          infos@icube.ch
//
// (C)Copyright 2004-2013
//**********************************************************************

// Automatically generated from productions

package icube.xmlpdu.auto;
import icube.xmlpdu.infra.*;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLIDs
{

  public static String xmlIdToStr(int xmlId) throws XmlPduException {
        String _xmlStr = null;
        
        Enumeration<String> _keys = hashTable_.keys();
        
        while (_keys.hasMoreElements()) {
          String _key = _keys.nextElement();
          int _value = (int)hashTable_.get(_key);
          
          if (xmlId == _value){
            _xmlStr = _key;
            break;
          }
        }
        
        if (_xmlStr == null){
          throw new XmlPduException("xmlIdToStr: unexpected xmlId .concat(Interger.toString(xmlId))");
        }
        
        return _xmlStr;
  }
  
  public static int xmlIdToInt(String xmlId) throws XmlPduException {
    try {
      Integer i = hashTable_.get(xmlId.toString());
      return i.intValue();
    } catch (NullPointerException e) {
      throw new XmlPduException("Unknown identifier - ".concat(xmlId));
    }
  }

  public static final int xtUnknown = 0;
  public static final int xtStartTag = 1;
  public static final int xtStopTag = 2;
  public static final int xtEndOfBuffer = 3;
  public static final int xtComment = 4;
//##1 Automatically generated
        public static final int XML_Access = 1;
        public static final int XML_AccessRequest = 2;
        public static final int XML_AccessRequestAction = 3;
        public static final int XML_AccessRequestBody = 4;
        public static final int XML_AccessRequestGet = 5;
        public static final int XML_AccessRequestGetWithSelection = 6;
        public static final int XML_AccessRequestSet = 7;
        public static final int XML_AccessRequestSetWithSelection = 8;
        public static final int XML_AccessRequestSpecification = 9;
        public static final int XML_AccessResponse = 10;
        public static final int XML_AccessResponseAction = 11;
        public static final int XML_AccessResponseBody = 12;
        public static final int XML_AccessResponseGet = 13;
        public static final int XML_AccessResponseSet = 14;
        public static final int XML_AccessResponseSpecification = 15;
        public static final int XML_ACSERequirement = 16;
        public static final int XML_ACSEServiceProvider = 17;
        public static final int XML_ACSEServiceUser = 18;
        public static final int XML_ActionRequest = 19;
        public static final int XML_ActionRequestForNextPBlock = 20;
        public static final int XML_ActionRequestNormal = 21;
        public static final int XML_ActionRequestWithFirstPBlock = 22;
        public static final int XML_ActionRequestWithList = 23;
        public static final int XML_ActionRequestWithListAndWithFirstPBlock = 24;
        public static final int XML_ActionRequestWithPBlock = 25;
        public static final int XML_ActionResponse = 26;
        public static final int XML_ActionResponseForNextPBlock = 27;
        public static final int XML_ActionResponseNormal = 28;
        public static final int XML_ActionResponseWithList = 29;
        public static final int XML_ActionResponseWithPBlock = 30;
        public static final int XML_ActionResult = 31;
        public static final int XML_AEQualifier = 32;
        public static final int XML_AgreedKey = 33;
        public static final int XML_ApplicationContextName = 34;
        public static final int XML_ApplicationReference = 35;
        public static final int XML_APTitle = 36;
        public static final int XML_Array = 37;
        public static final int XML_ArrayTypeDescription = 38;
        public static final int XML_AssociationRequest = 39;
        public static final int XML_AssociationResponse = 40;
        public static final int XML_AssociationResult = 41;
        public static final int XML_AttributeDescriptor = 42;
        public static final int XML_AttributeDescriptorWithSelection = 43;
        public static final int XML_AuthenticationValue = 44;
        public static final int XML_Bcd = 45;
        public static final int XML_BERCOSEMpdu = 46;
        public static final int XML_BitString = 47;
        public static final int XML_BlockControl = 48;
        public static final int XML_BlockNumberAccess = 49;
        public static final int XML_Boolean = 50;
        public static final int XML_ClassId = 51;
        public static final int XML_CompactArray = 52;
        public static final int XML_ConfirmedServiceError = 53;
        public static final int XML_Conformance = 54;
        public static final int XML_COSEMpdu = 55;
        public static final int XML_Data = 56;
        public static final int XML_DataAccessResult = 57;
        public static final int XML_DataBlock_G = 58;
        public static final int XML_DataBlock_SA = 59;
        public static final int XML_DataBlockGResult = 60;
        public static final int XML_DataBlockResult = 61;
        public static final int XML_DataNotification = 62;
        public static final int XML_Date = 63;
        public static final int XML_DateTime = 64;
        public static final int XML_Definition = 65;
        public static final int XML_DontCare = 66;
        public static final int XML_Enum = 67;
        public static final int XML_EventNotificationRequest = 68;
        public static final int XML_ExceptionResponse = 69;
        public static final int XML_ExceptionServiceError = 70;
        public static final int XML_ExceptionStateError = 71;
        public static final int XML_Float32 = 72;
        public static final int XML_Float64 = 73;
        public static final int XML_FloatingPoint = 74;
        public static final int XML_GeneralBlockTransfer = 75;
        public static final int XML_GeneralCiphering = 76;
        public static final int XML_GeneralDedCiphering = 77;
        public static final int XML_GeneralGloCiphering = 78;
        public static final int XML_GeneralSigning = 79;
        public static final int XML_GetDataResult = 80;
        public static final int XML_GetRequest = 81;
        public static final int XML_GetRequestForNextDatablock = 82;
        public static final int XML_GetRequestNormal = 83;
        public static final int XML_GetRequestWithList = 84;
        public static final int XML_GetResponse = 85;
        public static final int XML_GetResponseNormal = 86;
        public static final int XML_GetResponseWithDataBlock = 87;
        public static final int XML_GetResponseWithList = 88;
        public static final int XML_HardwareResource = 89;
        public static final int XML_IdentifiedKey = 90;
        public static final int XML_ImplementationData = 91;
        public static final int XML_InformationReportRequest = 92;
        public static final int XML_Initiate = 93;
        public static final int XML_InitiateRequest = 94;
        public static final int XML_InitiateResponse = 95;
        public static final int XML_Integer16 = 96;
        public static final int XML_Integer32 = 97;
        public static final int XML_Integer64 = 98;
        public static final int XML_Integer8 = 99;
        public static final int XML_InvocationId = 100;
        public static final int XML_InvokeIdAndPriority = 101;
        public static final int XML_KekId = 102;
        public static final int XML_KeyId = 103;
        public static final int XML_KeyInfo = 104;
        public static final int XML_ListOfAccessRequestSpecification = 105;
        public static final int XML_ListOfAccessResponseSpecification = 106;
        public static final int XML_ListOfAttributeDescriptorWithSelection = 107;
        public static final int XML_ListOfData = 108;
        public static final int XML_ListOfDataAccessResult = 109;
        public static final int XML_ListOfGetDataResult = 110;
        public static final int XML_ListOfMethodDescriptor = 111;
        public static final int XML_ListOfSingleActionResponse = 112;
        public static final int XML_ListOfVariableAccessSpecifications = 113;
        public static final int XML_LoadDataSet = 114;
        public static final int XML_LongInvokeIdAndPriority = 115;
        public static final int XML_MechanismName = 116;
        public static final int XML_MethodDescriptor = 117;
        public static final int XML_NotificationBody = 118;
        public static final int XML_NullData = 119;
        public static final int XML_ObjectAttributeId = 120;
        public static final int XML_ObjectInstanceId = 121;
        public static final int XML_ObjectMethodId = 122;
        public static final int XML_ObjectName = 123;
        public static final int XML_OctetString = 124;
        public static final int XML_OtherError = 125;
        public static final int XML_ParametrisedAccess = 126;
        public static final int XML_ProtocolVersion = 127;
        public static final int XML_ReadDataBlockAccess = 128;
        public static final int XML_ReadRequest = 129;
        public static final int XML_ReadResponse = 130;
        public static final int XML_ReleaseRequest = 131;
        public static final int XML_ReleaseRequestReason = 132;
        public static final int XML_ReleaseResponse = 133;
        public static final int XML_ReleaseResponseReason = 134;
        public static final int XML_ResultSourceDiagnostic = 135;
        public static final int XML_SelectiveAccessDescriptor = 136;
        public static final int XML_Service = 137;
        public static final int XML_ServiceError = 138;
        public static final int XML_SetRequest = 139;
        public static final int XML_SetRequestNormal = 140;
        public static final int XML_SetRequestWithDataBlock = 141;
        public static final int XML_SetRequestWithFirstDataBlock = 142;
        public static final int XML_SetRequestWithList = 143;
        public static final int XML_SetRequestWithListAndWithFirstDatablock = 144;
        public static final int XML_SetResponse = 145;
        public static final int XML_SetResponseForDataBlock = 146;
        public static final int XML_SetResponseForLastDataBlock = 147;
        public static final int XML_SetResponseForLastDataBlockWithList = 148;
        public static final int XML_SetResponseNormal = 149;
        public static final int XML_SetResponseWithList = 150;
        public static final int XML_SingleActionResponse = 151;
        public static final int XML_SingleReadResponse = 152;
        public static final int XML_SingleWriteResponse = 153;
        public static final int XML_Structure = 154;
        public static final int XML_StructureTypeDescription = 155;
        public static final int XML_Task = 156;
        public static final int XML_Time = 157;
        public static final int XML_TypeDescription = 158;
        public static final int XML_UnconfirmedWriteRequest = 159;
        public static final int XML_Unsigned16 = 160;
        public static final int XML_Unsigned32 = 161;
        public static final int XML_Unsigned64 = 162;
        public static final int XML_Unsigned8 = 163;
        public static final int XML_UTF8String = 164;
        public static final int XML_VariableAccessSpecification = 165;
        public static final int XML_VdeStateError = 166;
        public static final int XML_VisibleString = 167;
        public static final int XML_WrappedKey = 168;
        public static final int XML_WriteDataBlockAccess = 169;
        public static final int XML_WriteRequest = 170;
        public static final int XML_WriteResponse = 171;
        public static final int XML_zDummy = 172;
        public static final int XMLAccess = 173;
        public static final int XMLAccessParameters = 174;
        public static final int XMLAccessRequest = 175;
        public static final int XMLAccessRequestAction = 176;
        public static final int XMLAccessRequestBody = 177;
        public static final int XMLAccessRequestGet = 178;
        public static final int XMLAccessRequestGetWithSelection = 179;
        public static final int XMLAccessRequestListOfData = 180;
        public static final int XMLAccessRequestSet = 181;
        public static final int XMLAccessRequestSetWithSelection = 182;
        public static final int XMLAccessRequestSpecification = 183;
        public static final int XMLAccessResponse = 184;
        public static final int XMLAccessResponseAction = 185;
        public static final int XMLAccessResponseBody = 186;
        public static final int XMLAccessResponseGet = 187;
        public static final int XMLAccessResponseListOfData = 188;
        public static final int XMLAccessResponseSet = 189;
        public static final int XMLAccessResponseSpecification = 190;
        public static final int XMLAccessSelection = 191;
        public static final int XMLAccessSelector = 192;
        public static final int XMLACSEServiceProvider = 193;
        public static final int XMLACSEServiceUser = 194;
        public static final int XMLActionRequest = 195;
        public static final int XMLActionRequestForNextPBlock = 196;
        public static final int XMLActionRequestNormal = 197;
        public static final int XMLActionRequestWithFirstPBlock = 198;
        public static final int XMLActionRequestWithList = 199;
        public static final int XMLActionRequestWithListAndFirstPBlock = 200;
        public static final int XMLActionRequestWithPBlock = 201;
        public static final int XMLActionResponse = 202;
        public static final int XMLActionResponseForNextPBlock = 203;
        public static final int XMLActionResponseNormal = 204;
        public static final int XMLActionResponseWithList = 205;
        public static final int XMLActionResponseWithPBlock = 206;
        public static final int XMLAgreedKey = 207;
        public static final int XMLApplicationContextName = 208;
        public static final int XMLApplicationReference = 209;
        public static final int XMLArray = 210;
        public static final int XMLArrayContent = 211;
        public static final int XMLAssociationRequest = 212;
        public static final int XMLAssociationResponse = 213;
        public static final int XMLAssociationResult = 214;
        public static final int XMLAttributeDescriptor = 215;
        public static final int XMLAttributeDescriptorList = 216;
        public static final int XMLAttributeId = 217;
        public static final int XMLAttributeValue = 218;
        public static final int XMLBcd = 219;
        public static final int XMLBitString = 220;
        public static final int XMLBlockControl = 221;
        public static final int XMLBlockData = 222;
        public static final int XMLBlockNumber = 223;
        public static final int XMLBlockNumberAccess = 224;
        public static final int XMLBlockNumberAck = 225;
        public static final int XMLBoolean = 226;
        public static final int XMLCalledAEInvocationId = 227;
        public static final int XMLCalledAEQualifier = 228;
        public static final int XMLCalledAPInvocationId = 229;
        public static final int XMLCalledAPTitle = 230;
        public static final int XMLCallingAEInvocationId = 231;
        public static final int XMLCallingAEQualifier = 232;
        public static final int XMLCallingAPInvocationId = 233;
        public static final int XMLCallingAPTitle = 234;
        public static final int XMLCallingAuthenticationValue = 235;
        public static final int XMLCipheredContent = 236;
        public static final int XMLCipheredService = 237;
        public static final int XMLClassId = 238;
        public static final int XMLCompactArray = 239;
        public static final int XMLConfirmedServiceError = 240;
        public static final int XMLConformanceBit = 241;
        public static final int XMLContent = 242;
        public static final int XMLContentDescription = 243;
        public static final int XMLCurrentTime = 244;
        public static final int XMLData = 245;
        public static final int XMLDataAccessError = 246;
        public static final int XMLDataAccessResult = 247;
        public static final int XMLDataBlock = 248;
        public static final int XMLDataBlockResult = 249;
        public static final int XMLDataNotification = 250;
        public static final int XMLDataValue = 251;
        public static final int XMLDate = 252;
        public static final int XMLDateTime = 253;
        public static final int XMLded_ActionRequest = 254;
        public static final int XMLded_ActionResponse = 255;
        public static final int XMLded_ConfirmedServiceError = 256;
        public static final int XMLded_EventNotificationRequest = 257;
        public static final int XMLded_GetRequest = 258;
        public static final int XMLded_GetResponse = 259;
        public static final int XMLded_InformationReportRequest = 260;
        public static final int XMLded_InitiateRequest = 261;
        public static final int XMLded_InitiateResponse = 262;
        public static final int XMLded_ReadRequest = 263;
        public static final int XMLded_ReadResponse = 264;
        public static final int XMLded_SetRequest = 265;
        public static final int XMLded_SetResponse = 266;
        public static final int XMLded_UnconfirmedWriteRequest = 267;
        public static final int XMLded_WriteRequest = 268;
        public static final int XMLded_WriteResponse = 269;
        public static final int XMLDedicatedKey = 270;
        public static final int XMLDefinition = 271;
        public static final int XMLDontCare = 272;
        public static final int XMLDoubleLong = 273;
        public static final int XMLDoubleLongUnsigned = 274;
        public static final int XMLEnum = 275;
        public static final int XMLEventNotificationRequest = 276;
        public static final int XMLExceptionResponse = 277;
        public static final int XMLFloat32 = 278;
        public static final int XMLFloat64 = 279;
        public static final int XMLFloatingPoint = 280;
        public static final int XMLGeneralBlockTransfer = 281;
        public static final int XMLGeneralCiphering = 282;
        public static final int XMLGeneralDedCiphering = 283;
        public static final int XMLGeneralGloCiphering = 284;
        public static final int XMLGeneralSigning = 285;
        public static final int XMLGetRequest = 286;
        public static final int XMLGetRequestForNextDataBlock = 287;
        public static final int XMLGetRequestNormal = 288;
        public static final int XMLGetRequestWithList = 289;
        public static final int XMLGetResponse = 290;
        public static final int XMLGetResponseNormal = 291;
        public static final int XMLGetResponseWithDataBlock = 292;
        public static final int XMLGetResponseWithList = 293;
        public static final int XMLglo_ActionRequest = 294;
        public static final int XMLglo_ActionResponse = 295;
        public static final int XMLglo_ConfirmedServiceError = 296;
        public static final int XMLglo_GetRequest = 297;
        public static final int XMLglo_GetResponse = 298;
        public static final int XMLglo_InformationReportRequest = 299;
        public static final int XMLglo_InitiateRequest = 300;
        public static final int XMLglo_InitiateResponse = 301;
        public static final int XMLglo_ReadRequest = 302;
        public static final int XMLglo_ReadResponse = 303;
        public static final int XMLglo_SetRequest = 304;
        public static final int XMLglo_SetResponse = 305;
        public static final int XMLglo_UnconfirmedWriteRequest = 306;
        public static final int XMLglo_WriteRequest = 307;
        public static final int XMLglo_WriteResponse = 308;
        public static final int XMLHardwareResource = 309;
        public static final int XMLIdentifiedKey = 310;
        public static final int XMLIgnore = 311;
        public static final int XMLImplementationInformation = 312;
        public static final int XMLInformationReportRequest = 313;
        public static final int XMLInitiate = 314;
        public static final int XMLInitiateRequest = 315;
        public static final int XMLInitiateResponse = 316;
        public static final int XMLInstanceId = 317;
        public static final int XMLInteger = 318;
        public static final int XMLInvokeIdAndPriority = 319;
        public static final int XMLKekId = 320;
        public static final int XMLKeyCipheredData = 321;
        public static final int XMLKeyId = 322;
        public static final int XMLKeyInfo = 323;
        public static final int XMLKeyParameters = 324;
        public static final int XMLLastBlock = 325;
        public static final int XMLListOfData = 326;
        public static final int XMLListOfSingleActionResponse = 327;
        public static final int XMLListOfVariableAccessSpecification = 328;
        public static final int XMLLoadDataSet = 329;
        public static final int XMLLong = 330;
        public static final int XMLLong64 = 331;
        public static final int XMLLong64Unsigned = 332;
        public static final int XMLLongInvokeIdAndPriority = 333;
        public static final int XMLLongUnsigned = 334;
        public static final int XMLMechanismName = 335;
        public static final int XMLMethodDescriptor = 336;
        public static final int XMLMethodDescriptorList = 337;
        public static final int XMLMethodId = 338;
        public static final int XMLMethodInvocationParameters = 339;
        public static final int XMLName = 340;
        public static final int XMLNegotiatedConformance = 341;
        public static final int XMLNegotiatedDlmsVersionNumber = 342;
        public static final int XMLNegotiatedMaxPduSize = 343;
        public static final int XMLNegotiatedQualityOfService = 344;
        public static final int XMLNotificationBody = 345;
        public static final int XMLNullData = 346;
        public static final int XMLNumberOfElements = 347;
        public static final int XMLOctetString = 348;
        public static final int XMLOriginatorSystemTitle = 349;
        public static final int XMLOtherError = 350;
        public static final int XMLOtherInformation = 351;
        public static final int XMLParameter = 352;
        public static final int XMLParameterisedAccess = 353;
        public static final int XMLPBlock = 354;
        public static final int XMLProposedConformance = 355;
        public static final int XMLProposedDlmsVersionNumber = 356;
        public static final int XMLProposedMaxPduSize = 357;
        public static final int XMLProposedQualityOfService = 358;
        public static final int XMLProtocolVersion = 359;
        public static final int XMLQty = 360;
        public static final int XMLRawData = 361;
        public static final int XMLReadDataBlockAccess = 362;
        public static final int XMLReadRequest = 363;
        public static final int XMLReadResponse = 364;
        public static final int XMLReason = 365;
        public static final int XMLRecipientSystemTitle = 366;
        public static final int XMLReleaseRequest = 367;
        public static final int XMLReleaseResponse = 368;
        public static final int XMLResponderACSERequirement = 369;
        public static final int XMLRespondingAEInvocationId = 370;
        public static final int XMLRespondingAEQualifier = 371;
        public static final int XMLRespondingAPInvocationId = 372;
        public static final int XMLRespondingAPTitle = 373;
        public static final int XMLRespondingAuthenticationValue = 374;
        public static final int XMLResponseAllowed = 375;
        public static final int XMLResult = 376;
        public static final int XMLResultSourceDiagnostic = 377;
        public static final int XMLReturnParameters = 378;
        public static final int XMLSelector = 379;
        public static final int XMLSenderACSERequirements = 380;
        public static final int XMLService = 381;
        public static final int XMLServiceError = 382;
        public static final int XMLSetRequest = 383;
        public static final int XMLSetRequestNormal = 384;
        public static final int XMLSetRequestWithDataBlock = 385;
        public static final int XMLSetRequestWithFirstDataBlock = 386;
        public static final int XMLSetRequestWithList = 387;
        public static final int XMLSetRequestWithListAndWithFirstDatablock = 388;
        public static final int XMLSetResponse = 389;
        public static final int XMLSetResponseForDataBlock = 390;
        public static final int XMLSetResponseForLastDataBlock = 391;
        public static final int XMLSetResponseForLastDataBlockWithList = 392;
        public static final int XMLSetResponseNormal = 393;
        public static final int XMLSetResponseWithList = 394;
        public static final int XMLSignature = 395;
        public static final int XMLStateError = 396;
        public static final int XMLStructure = 397;
        public static final int XMLSuccess = 398;
        public static final int XMLSystemTitle = 399;
        public static final int XMLTask = 400;
        public static final int XMLTime = 401;
        public static final int XMLTransactionId = 402;
        public static final int XMLTypeDescription = 403;
        public static final int XMLUnconfirmedWriteRequest = 404;
        public static final int XMLUnsigned = 405;
        public static final int XMLUserInformation = 406;
        public static final int XMLUTF8String = 407;
        public static final int XMLVaaName = 408;
        public static final int XMLValue = 409;
        public static final int XMLValueList = 410;
        public static final int XMLVariableName = 411;
        public static final int XMLVdeStateError = 412;
        public static final int XMLVisibleString = 413;
        public static final int XMLWrappedKey = 414;
        public static final int XMLWriteDataBlockAccess = 415;
        public static final int XMLWriteRequest = 416;
        public static final int XMLWriteResponse = 417;

    private static Hashtable<String, Integer> hashTable_ = new Hashtable<String, Integer>() {{
//    put("_ACSERequirement", new Integer(XML_ACSERequirement));
//##2 Automatically generated
            put( "_Access", new Integer(XML_Access));,
            put( "_AccessRequest", new Integer(XML_AccessRequest));,
            put( "_AccessRequestAction", new Integer(XML_AccessRequestAction));,
            put( "_AccessRequestBody", new Integer(XML_AccessRequestBody));,
            put( "_AccessRequestGet", new Integer(XML_AccessRequestGet));,
            put( "_AccessRequestGetWithSelection", new Integer(XML_AccessRequestGetWithSelection));,
            put( "_AccessRequestSet", new Integer(XML_AccessRequestSet));,
            put( "_AccessRequestSetWithSelection", new Integer(XML_AccessRequestSetWithSelection));,
            put( "_AccessRequestSpecification", new Integer(XML_AccessRequestSpecification));,
            put( "_AccessResponse", new Integer(XML_AccessResponse));,
            put( "_AccessResponseAction", new Integer(XML_AccessResponseAction));,
            put( "_AccessResponseBody", new Integer(XML_AccessResponseBody));,
            put( "_AccessResponseGet", new Integer(XML_AccessResponseGet));,
            put( "_AccessResponseSet", new Integer(XML_AccessResponseSet));,
            put( "_AccessResponseSpecification", new Integer(XML_AccessResponseSpecification));,
            put( "_ACSERequirement", new Integer(XML_ACSERequirement));,
            put( "_ACSEServiceProvider", new Integer(XML_ACSEServiceProvider));,
            put( "_ACSEServiceUser", new Integer(XML_ACSEServiceUser));,
            put( "_ActionRequest", new Integer(XML_ActionRequest));,
            put( "_ActionRequestForNextPBlock", new Integer(XML_ActionRequestForNextPBlock));,
            put( "_ActionRequestNormal", new Integer(XML_ActionRequestNormal));,
            put( "_ActionRequestWithFirstPBlock", new Integer(XML_ActionRequestWithFirstPBlock));,
            put( "_ActionRequestWithList", new Integer(XML_ActionRequestWithList));,
            put( "_ActionRequestWithListAndWithFirstPBlock", new Integer(XML_ActionRequestWithListAndWithFirstPBlock));,
            put( "_ActionRequestWithPBlock", new Integer(XML_ActionRequestWithPBlock));,
            put( "_ActionResponse", new Integer(XML_ActionResponse));,
            put( "_ActionResponseForNextPBlock", new Integer(XML_ActionResponseForNextPBlock));,
            put( "_ActionResponseNormal", new Integer(XML_ActionResponseNormal));,
            put( "_ActionResponseWithList", new Integer(XML_ActionResponseWithList));,
            put( "_ActionResponseWithPBlock", new Integer(XML_ActionResponseWithPBlock));,
            put( "_ActionResult", new Integer(XML_ActionResult));,
            put( "_AEQualifier", new Integer(XML_AEQualifier));,
            put( "_AgreedKey", new Integer(XML_AgreedKey));,
            put( "_ApplicationContextName", new Integer(XML_ApplicationContextName));,
            put( "_ApplicationReference", new Integer(XML_ApplicationReference));,
            put( "_APTitle", new Integer(XML_APTitle));,
            put( "_Array", new Integer(XML_Array));,
            put( "_ArrayTypeDescription", new Integer(XML_ArrayTypeDescription));,
            put( "_AssociationRequest", new Integer(XML_AssociationRequest));,
            put( "_AssociationResponse", new Integer(XML_AssociationResponse));,
            put( "_AssociationResult", new Integer(XML_AssociationResult));,
            put( "_AttributeDescriptor", new Integer(XML_AttributeDescriptor));,
            put( "_AttributeDescriptorWithSelection", new Integer(XML_AttributeDescriptorWithSelection));,
            put( "_AuthenticationValue", new Integer(XML_AuthenticationValue));,
            put( "_Bcd", new Integer(XML_Bcd));,
            put( "_BERCOSEMpdu", new Integer(XML_BERCOSEMpdu));,
            put( "_BitString", new Integer(XML_BitString));,
            put( "_BlockControl", new Integer(XML_BlockControl));,
            put( "_BlockNumberAccess", new Integer(XML_BlockNumberAccess));,
            put( "_Boolean", new Integer(XML_Boolean));,
            put( "_ClassId", new Integer(XML_ClassId));,
            put( "_CompactArray", new Integer(XML_CompactArray));,
            put( "_ConfirmedServiceError", new Integer(XML_ConfirmedServiceError));,
            put( "_Conformance", new Integer(XML_Conformance));,
            put( "_COSEMpdu", new Integer(XML_COSEMpdu));,
            put( "_Data", new Integer(XML_Data));,
            put( "_DataAccessResult", new Integer(XML_DataAccessResult));,
            put( "_DataBlock_G", new Integer(XML_DataBlock_G));,
            put( "_DataBlock_SA", new Integer(XML_DataBlock_SA));,
            put( "_DataBlockGResult", new Integer(XML_DataBlockGResult));,
            put( "_DataBlockResult", new Integer(XML_DataBlockResult));,
            put( "_DataNotification", new Integer(XML_DataNotification));,
            put( "_Date", new Integer(XML_Date));,
            put( "_DateTime", new Integer(XML_DateTime));,
            put( "_Definition", new Integer(XML_Definition));,
            put( "_DontCare", new Integer(XML_DontCare));,
            put( "_Enum", new Integer(XML_Enum));,
            put( "_EventNotificationRequest", new Integer(XML_EventNotificationRequest));,
            put( "_ExceptionResponse", new Integer(XML_ExceptionResponse));,
            put( "_ExceptionServiceError", new Integer(XML_ExceptionServiceError));,
            put( "_ExceptionStateError", new Integer(XML_ExceptionStateError));,
            put( "_Float32", new Integer(XML_Float32));,
            put( "_Float64", new Integer(XML_Float64));,
            put( "_FloatingPoint", new Integer(XML_FloatingPoint));,
            put( "_GeneralBlockTransfer", new Integer(XML_GeneralBlockTransfer));,
            put( "_GeneralCiphering", new Integer(XML_GeneralCiphering));,
            put( "_GeneralDedCiphering", new Integer(XML_GeneralDedCiphering));,
            put( "_GeneralGloCiphering", new Integer(XML_GeneralGloCiphering));,
            put( "_GeneralSigning", new Integer(XML_GeneralSigning));,
            put( "_GetDataResult", new Integer(XML_GetDataResult));,
            put( "_GetRequest", new Integer(XML_GetRequest));,
            put( "_GetRequestForNextDatablock", new Integer(XML_GetRequestForNextDatablock));,
            put( "_GetRequestNormal", new Integer(XML_GetRequestNormal));,
            put( "_GetRequestWithList", new Integer(XML_GetRequestWithList));,
            put( "_GetResponse", new Integer(XML_GetResponse));,
            put( "_GetResponseNormal", new Integer(XML_GetResponseNormal));,
            put( "_GetResponseWithDataBlock", new Integer(XML_GetResponseWithDataBlock));,
            put( "_GetResponseWithList", new Integer(XML_GetResponseWithList));,
            put( "_HardwareResource", new Integer(XML_HardwareResource));,
            put( "_IdentifiedKey", new Integer(XML_IdentifiedKey));,
            put( "_ImplementationData", new Integer(XML_ImplementationData));,
            put( "_InformationReportRequest", new Integer(XML_InformationReportRequest));,
            put( "_Initiate", new Integer(XML_Initiate));,
            put( "_InitiateRequest", new Integer(XML_InitiateRequest));,
            put( "_InitiateResponse", new Integer(XML_InitiateResponse));,
            put( "_Integer16", new Integer(XML_Integer16));,
            put( "_Integer32", new Integer(XML_Integer32));,
            put( "_Integer64", new Integer(XML_Integer64));,
            put( "_Integer8", new Integer(XML_Integer8));,
            put( "_InvocationId", new Integer(XML_InvocationId));,
            put( "_InvokeIdAndPriority", new Integer(XML_InvokeIdAndPriority));,
            put( "_KekId", new Integer(XML_KekId));,
            put( "_KeyId", new Integer(XML_KeyId));,
            put( "_KeyInfo", new Integer(XML_KeyInfo));,
            put( "_ListOfAccessRequestSpecification", new Integer(XML_ListOfAccessRequestSpecification));,
            put( "_ListOfAccessResponseSpecification", new Integer(XML_ListOfAccessResponseSpecification));,
            put( "_ListOfAttributeDescriptorWithSelection", new Integer(XML_ListOfAttributeDescriptorWithSelection));,
            put( "_ListOfData", new Integer(XML_ListOfData));,
            put( "_ListOfDataAccessResult", new Integer(XML_ListOfDataAccessResult));,
            put( "_ListOfGetDataResult", new Integer(XML_ListOfGetDataResult));,
            put( "_ListOfMethodDescriptor", new Integer(XML_ListOfMethodDescriptor));,
            put( "_ListOfSingleActionResponse", new Integer(XML_ListOfSingleActionResponse));,
            put( "_ListOfVariableAccessSpecifications", new Integer(XML_ListOfVariableAccessSpecifications));,
            put( "_LoadDataSet", new Integer(XML_LoadDataSet));,
            put( "_LongInvokeIdAndPriority", new Integer(XML_LongInvokeIdAndPriority));,
            put( "_MechanismName", new Integer(XML_MechanismName));,
            put( "_MethodDescriptor", new Integer(XML_MethodDescriptor));,
            put( "_NotificationBody", new Integer(XML_NotificationBody));,
            put( "_NullData", new Integer(XML_NullData));,
            put( "_ObjectAttributeId", new Integer(XML_ObjectAttributeId));,
            put( "_ObjectInstanceId", new Integer(XML_ObjectInstanceId));,
            put( "_ObjectMethodId", new Integer(XML_ObjectMethodId));,
            put( "_ObjectName", new Integer(XML_ObjectName));,
            put( "_OctetString", new Integer(XML_OctetString));,
            put( "_OtherError", new Integer(XML_OtherError));,
            put( "_ParametrisedAccess", new Integer(XML_ParametrisedAccess));,
            put( "_ProtocolVersion", new Integer(XML_ProtocolVersion));,
            put( "_ReadDataBlockAccess", new Integer(XML_ReadDataBlockAccess));,
            put( "_ReadRequest", new Integer(XML_ReadRequest));,
            put( "_ReadResponse", new Integer(XML_ReadResponse));,
            put( "_ReleaseRequest", new Integer(XML_ReleaseRequest));,
            put( "_ReleaseRequestReason", new Integer(XML_ReleaseRequestReason));,
            put( "_ReleaseResponse", new Integer(XML_ReleaseResponse));,
            put( "_ReleaseResponseReason", new Integer(XML_ReleaseResponseReason));,
            put( "_ResultSourceDiagnostic", new Integer(XML_ResultSourceDiagnostic));,
            put( "_SelectiveAccessDescriptor", new Integer(XML_SelectiveAccessDescriptor));,
            put( "_Service", new Integer(XML_Service));,
            put( "_ServiceError", new Integer(XML_ServiceError));,
            put( "_SetRequest", new Integer(XML_SetRequest));,
            put( "_SetRequestNormal", new Integer(XML_SetRequestNormal));,
            put( "_SetRequestWithDataBlock", new Integer(XML_SetRequestWithDataBlock));,
            put( "_SetRequestWithFirstDataBlock", new Integer(XML_SetRequestWithFirstDataBlock));,
            put( "_SetRequestWithList", new Integer(XML_SetRequestWithList));,
            put( "_SetRequestWithListAndWithFirstDatablock", new Integer(XML_SetRequestWithListAndWithFirstDatablock));,
            put( "_SetResponse", new Integer(XML_SetResponse));,
            put( "_SetResponseForDataBlock", new Integer(XML_SetResponseForDataBlock));,
            put( "_SetResponseForLastDataBlock", new Integer(XML_SetResponseForLastDataBlock));,
            put( "_SetResponseForLastDataBlockWithList", new Integer(XML_SetResponseForLastDataBlockWithList));,
            put( "_SetResponseNormal", new Integer(XML_SetResponseNormal));,
            put( "_SetResponseWithList", new Integer(XML_SetResponseWithList));,
            put( "_SingleActionResponse", new Integer(XML_SingleActionResponse));,
            put( "_SingleReadResponse", new Integer(XML_SingleReadResponse));,
            put( "_SingleWriteResponse", new Integer(XML_SingleWriteResponse));,
            put( "_Structure", new Integer(XML_Structure));,
            put( "_StructureTypeDescription", new Integer(XML_StructureTypeDescription));,
            put( "_Task", new Integer(XML_Task));,
            put( "_Time", new Integer(XML_Time));,
            put( "_TypeDescription", new Integer(XML_TypeDescription));,
            put( "_UnconfirmedWriteRequest", new Integer(XML_UnconfirmedWriteRequest));,
            put( "_Unsigned16", new Integer(XML_Unsigned16));,
            put( "_Unsigned32", new Integer(XML_Unsigned32));,
            put( "_Unsigned64", new Integer(XML_Unsigned64));,
            put( "_Unsigned8", new Integer(XML_Unsigned8));,
            put( "_UTF8String", new Integer(XML_UTF8String));,
            put( "_VariableAccessSpecification", new Integer(XML_VariableAccessSpecification));,
            put( "_VdeStateError", new Integer(XML_VdeStateError));,
            put( "_VisibleString", new Integer(XML_VisibleString));,
            put( "_WrappedKey", new Integer(XML_WrappedKey));,
            put( "_WriteDataBlockAccess", new Integer(XML_WriteDataBlockAccess));,
            put( "_WriteRequest", new Integer(XML_WriteRequest));,
            put( "_WriteResponse", new Integer(XML_WriteResponse));,
            put( "_zDummy", new Integer(XML_zDummy));,
            put( "Access", new Integer(XMLAccess));,
            put( "AccessParameters", new Integer(XMLAccessParameters));,
            put( "AccessRequest", new Integer(XMLAccessRequest));,
            put( "AccessRequestAction", new Integer(XMLAccessRequestAction));,
            put( "AccessRequestBody", new Integer(XMLAccessRequestBody));,
            put( "AccessRequestGet", new Integer(XMLAccessRequestGet));,
            put( "AccessRequestGetWithSelection", new Integer(XMLAccessRequestGetWithSelection));,
            put( "AccessRequestListOfData", new Integer(XMLAccessRequestListOfData));,
            put( "AccessRequestSet", new Integer(XMLAccessRequestSet));,
            put( "AccessRequestSetWithSelection", new Integer(XMLAccessRequestSetWithSelection));,
            put( "AccessRequestSpecification", new Integer(XMLAccessRequestSpecification));,
            put( "AccessResponse", new Integer(XMLAccessResponse));,
            put( "AccessResponseAction", new Integer(XMLAccessResponseAction));,
            put( "AccessResponseBody", new Integer(XMLAccessResponseBody));,
            put( "AccessResponseGet", new Integer(XMLAccessResponseGet));,
            put( "AccessResponseListOfData", new Integer(XMLAccessResponseListOfData));,
            put( "AccessResponseSet", new Integer(XMLAccessResponseSet));,
            put( "AccessResponseSpecification", new Integer(XMLAccessResponseSpecification));,
            put( "AccessSelection", new Integer(XMLAccessSelection));,
            put( "AccessSelector", new Integer(XMLAccessSelector));,
            put( "ACSEServiceProvider", new Integer(XMLACSEServiceProvider));,
            put( "ACSEServiceUser", new Integer(XMLACSEServiceUser));,
            put( "ActionRequest", new Integer(XMLActionRequest));,
            put( "ActionRequestForNextPBlock", new Integer(XMLActionRequestForNextPBlock));,
            put( "ActionRequestNormal", new Integer(XMLActionRequestNormal));,
            put( "ActionRequestWithFirstPBlock", new Integer(XMLActionRequestWithFirstPBlock));,
            put( "ActionRequestWithList", new Integer(XMLActionRequestWithList));,
            put( "ActionRequestWithListAndFirstPBlock", new Integer(XMLActionRequestWithListAndFirstPBlock));,
            put( "ActionRequestWithPBlock", new Integer(XMLActionRequestWithPBlock));,
            put( "ActionResponse", new Integer(XMLActionResponse));,
            put( "ActionResponseForNextPBlock", new Integer(XMLActionResponseForNextPBlock));,
            put( "ActionResponseNormal", new Integer(XMLActionResponseNormal));,
            put( "ActionResponseWithList", new Integer(XMLActionResponseWithList));,
            put( "ActionResponseWithPBlock", new Integer(XMLActionResponseWithPBlock));,
            put( "AgreedKey", new Integer(XMLAgreedKey));,
            put( "ApplicationContextName", new Integer(XMLApplicationContextName));,
            put( "ApplicationReference", new Integer(XMLApplicationReference));,
            put( "Array", new Integer(XMLArray));,
            put( "ArrayContent", new Integer(XMLArrayContent));,
            put( "AssociationRequest", new Integer(XMLAssociationRequest));,
            put( "AssociationResponse", new Integer(XMLAssociationResponse));,
            put( "AssociationResult", new Integer(XMLAssociationResult));,
            put( "AttributeDescriptor", new Integer(XMLAttributeDescriptor));,
            put( "AttributeDescriptorList", new Integer(XMLAttributeDescriptorList));,
            put( "AttributeId", new Integer(XMLAttributeId));,
            put( "AttributeValue", new Integer(XMLAttributeValue));,
            put( "Bcd", new Integer(XMLBcd));,
            put( "BitString", new Integer(XMLBitString));,
            put( "BlockControl", new Integer(XMLBlockControl));,
            put( "BlockData", new Integer(XMLBlockData));,
            put( "BlockNumber", new Integer(XMLBlockNumber));,
            put( "BlockNumberAccess", new Integer(XMLBlockNumberAccess));,
            put( "BlockNumberAck", new Integer(XMLBlockNumberAck));,
            put( "Boolean", new Integer(XMLBoolean));,
            put( "CalledAEInvocationId", new Integer(XMLCalledAEInvocationId));,
            put( "CalledAEQualifier", new Integer(XMLCalledAEQualifier));,
            put( "CalledAPInvocationId", new Integer(XMLCalledAPInvocationId));,
            put( "CalledAPTitle", new Integer(XMLCalledAPTitle));,
            put( "CallingAEInvocationId", new Integer(XMLCallingAEInvocationId));,
            put( "CallingAEQualifier", new Integer(XMLCallingAEQualifier));,
            put( "CallingAPInvocationId", new Integer(XMLCallingAPInvocationId));,
            put( "CallingAPTitle", new Integer(XMLCallingAPTitle));,
            put( "CallingAuthenticationValue", new Integer(XMLCallingAuthenticationValue));,
            put( "CipheredContent", new Integer(XMLCipheredContent));,
            put( "CipheredService", new Integer(XMLCipheredService));,
            put( "ClassId", new Integer(XMLClassId));,
            put( "CompactArray", new Integer(XMLCompactArray));,
            put( "ConfirmedServiceError", new Integer(XMLConfirmedServiceError));,
            put( "ConformanceBit", new Integer(XMLConformanceBit));,
            put( "Content", new Integer(XMLContent));,
            put( "ContentDescription", new Integer(XMLContentDescription));,
            put( "CurrentTime", new Integer(XMLCurrentTime));,
            put( "Data", new Integer(XMLData));,
            put( "DataAccessError", new Integer(XMLDataAccessError));,
            put( "DataAccessResult", new Integer(XMLDataAccessResult));,
            put( "DataBlock", new Integer(XMLDataBlock));,
            put( "DataBlockResult", new Integer(XMLDataBlockResult));,
            put( "DataNotification", new Integer(XMLDataNotification));,
            put( "DataValue", new Integer(XMLDataValue));,
            put( "Date", new Integer(XMLDate));,
            put( "DateTime", new Integer(XMLDateTime));,
            put( "ded_ActionRequest", new Integer(XMLded_ActionRequest));,
            put( "ded_ActionResponse", new Integer(XMLded_ActionResponse));,
            put( "ded_ConfirmedServiceError", new Integer(XMLded_ConfirmedServiceError));,
            put( "ded_EventNotificationRequest", new Integer(XMLded_EventNotificationRequest));,
            put( "ded_GetRequest", new Integer(XMLded_GetRequest));,
            put( "ded_GetResponse", new Integer(XMLded_GetResponse));,
            put( "ded_InformationReportRequest", new Integer(XMLded_InformationReportRequest));,
            put( "ded_InitiateRequest", new Integer(XMLded_InitiateRequest));,
            put( "ded_InitiateResponse", new Integer(XMLded_InitiateResponse));,
            put( "ded_ReadRequest", new Integer(XMLded_ReadRequest));,
            put( "ded_ReadResponse", new Integer(XMLded_ReadResponse));,
            put( "ded_SetRequest", new Integer(XMLded_SetRequest));,
            put( "ded_SetResponse", new Integer(XMLded_SetResponse));,
            put( "ded_UnconfirmedWriteRequest", new Integer(XMLded_UnconfirmedWriteRequest));,
            put( "ded_WriteRequest", new Integer(XMLded_WriteRequest));,
            put( "ded_WriteResponse", new Integer(XMLded_WriteResponse));,
            put( "DedicatedKey", new Integer(XMLDedicatedKey));,
            put( "Definition", new Integer(XMLDefinition));,
            put( "DontCare", new Integer(XMLDontCare));,
            put( "DoubleLong", new Integer(XMLDoubleLong));,
            put( "DoubleLongUnsigned", new Integer(XMLDoubleLongUnsigned));,
            put( "Enum", new Integer(XMLEnum));,
            put( "EventNotificationRequest", new Integer(XMLEventNotificationRequest));,
            put( "ExceptionResponse", new Integer(XMLExceptionResponse));,
            put( "Float32", new Integer(XMLFloat32));,
            put( "Float64", new Integer(XMLFloat64));,
            put( "FloatingPoint", new Integer(XMLFloatingPoint));,
            put( "GeneralBlockTransfer", new Integer(XMLGeneralBlockTransfer));,
            put( "GeneralCiphering", new Integer(XMLGeneralCiphering));,
            put( "GeneralDedCiphering", new Integer(XMLGeneralDedCiphering));,
            put( "GeneralGloCiphering", new Integer(XMLGeneralGloCiphering));,
            put( "GeneralSigning", new Integer(XMLGeneralSigning));,
            put( "GetRequest", new Integer(XMLGetRequest));,
            put( "GetRequestForNextDataBlock", new Integer(XMLGetRequestForNextDataBlock));,
            put( "GetRequestNormal", new Integer(XMLGetRequestNormal));,
            put( "GetRequestWithList", new Integer(XMLGetRequestWithList));,
            put( "GetResponse", new Integer(XMLGetResponse));,
            put( "GetResponseNormal", new Integer(XMLGetResponseNormal));,
            put( "GetResponseWithDataBlock", new Integer(XMLGetResponseWithDataBlock));,
            put( "GetResponseWithList", new Integer(XMLGetResponseWithList));,
            put( "glo_ActionRequest", new Integer(XMLglo_ActionRequest));,
            put( "glo_ActionResponse", new Integer(XMLglo_ActionResponse));,
            put( "glo_ConfirmedServiceError", new Integer(XMLglo_ConfirmedServiceError));,
            put( "glo_GetRequest", new Integer(XMLglo_GetRequest));,
            put( "glo_GetResponse", new Integer(XMLglo_GetResponse));,
            put( "glo_InformationReportRequest", new Integer(XMLglo_InformationReportRequest));,
            put( "glo_InitiateRequest", new Integer(XMLglo_InitiateRequest));,
            put( "glo_InitiateResponse", new Integer(XMLglo_InitiateResponse));,
            put( "glo_ReadRequest", new Integer(XMLglo_ReadRequest));,
            put( "glo_ReadResponse", new Integer(XMLglo_ReadResponse));,
            put( "glo_SetRequest", new Integer(XMLglo_SetRequest));,
            put( "glo_SetResponse", new Integer(XMLglo_SetResponse));,
            put( "glo_UnconfirmedWriteRequest", new Integer(XMLglo_UnconfirmedWriteRequest));,
            put( "glo_WriteRequest", new Integer(XMLglo_WriteRequest));,
            put( "glo_WriteResponse", new Integer(XMLglo_WriteResponse));,
            put( "HardwareResource", new Integer(XMLHardwareResource));,
            put( "IdentifiedKey", new Integer(XMLIdentifiedKey));,
            put( "Ignore", new Integer(XMLIgnore));,
            put( "ImplementationInformation", new Integer(XMLImplementationInformation));,
            put( "InformationReportRequest", new Integer(XMLInformationReportRequest));,
            put( "Initiate", new Integer(XMLInitiate));,
            put( "InitiateRequest", new Integer(XMLInitiateRequest));,
            put( "InitiateResponse", new Integer(XMLInitiateResponse));,
            put( "InstanceId", new Integer(XMLInstanceId));,
            put( "Integer", new Integer(XMLInteger));,
            put( "InvokeIdAndPriority", new Integer(XMLInvokeIdAndPriority));,
            put( "KekId", new Integer(XMLKekId));,
            put( "KeyCipheredData", new Integer(XMLKeyCipheredData));,
            put( "KeyId", new Integer(XMLKeyId));,
            put( "KeyInfo", new Integer(XMLKeyInfo));,
            put( "KeyParameters", new Integer(XMLKeyParameters));,
            put( "LastBlock", new Integer(XMLLastBlock));,
            put( "ListOfData", new Integer(XMLListOfData));,
            put( "ListOfSingleActionResponse", new Integer(XMLListOfSingleActionResponse));,
            put( "ListOfVariableAccessSpecification", new Integer(XMLListOfVariableAccessSpecification));,
            put( "LoadDataSet", new Integer(XMLLoadDataSet));,
            put( "Long", new Integer(XMLLong));,
            put( "Long64", new Integer(XMLLong64));,
            put( "Long64Unsigned", new Integer(XMLLong64Unsigned));,
            put( "LongInvokeIdAndPriority", new Integer(XMLLongInvokeIdAndPriority));,
            put( "LongUnsigned", new Integer(XMLLongUnsigned));,
            put( "MechanismName", new Integer(XMLMechanismName));,
            put( "MethodDescriptor", new Integer(XMLMethodDescriptor));,
            put( "MethodDescriptorList", new Integer(XMLMethodDescriptorList));,
            put( "MethodId", new Integer(XMLMethodId));,
            put( "MethodInvocationParameters", new Integer(XMLMethodInvocationParameters));,
            put( "Name", new Integer(XMLName));,
            put( "NegotiatedConformance", new Integer(XMLNegotiatedConformance));,
            put( "NegotiatedDlmsVersionNumber", new Integer(XMLNegotiatedDlmsVersionNumber));,
            put( "NegotiatedMaxPduSize", new Integer(XMLNegotiatedMaxPduSize));,
            put( "NegotiatedQualityOfService", new Integer(XMLNegotiatedQualityOfService));,
            put( "NotificationBody", new Integer(XMLNotificationBody));,
            put( "NullData", new Integer(XMLNullData));,
            put( "NumberOfElements", new Integer(XMLNumberOfElements));,
            put( "OctetString", new Integer(XMLOctetString));,
            put( "OriginatorSystemTitle", new Integer(XMLOriginatorSystemTitle));,
            put( "OtherError", new Integer(XMLOtherError));,
            put( "OtherInformation", new Integer(XMLOtherInformation));,
            put( "Parameter", new Integer(XMLParameter));,
            put( "ParameterisedAccess", new Integer(XMLParameterisedAccess));,
            put( "PBlock", new Integer(XMLPBlock));,
            put( "ProposedConformance", new Integer(XMLProposedConformance));,
            put( "ProposedDlmsVersionNumber", new Integer(XMLProposedDlmsVersionNumber));,
            put( "ProposedMaxPduSize", new Integer(XMLProposedMaxPduSize));,
            put( "ProposedQualityOfService", new Integer(XMLProposedQualityOfService));,
            put( "ProtocolVersion", new Integer(XMLProtocolVersion));,
            put( "Qty", new Integer(XMLQty));,
            put( "RawData", new Integer(XMLRawData));,
            put( "ReadDataBlockAccess", new Integer(XMLReadDataBlockAccess));,
            put( "ReadRequest", new Integer(XMLReadRequest));,
            put( "ReadResponse", new Integer(XMLReadResponse));,
            put( "Reason", new Integer(XMLReason));,
            put( "RecipientSystemTitle", new Integer(XMLRecipientSystemTitle));,
            put( "ReleaseRequest", new Integer(XMLReleaseRequest));,
            put( "ReleaseResponse", new Integer(XMLReleaseResponse));,
            put( "ResponderACSERequirement", new Integer(XMLResponderACSERequirement));,
            put( "RespondingAEInvocationId", new Integer(XMLRespondingAEInvocationId));,
            put( "RespondingAEQualifier", new Integer(XMLRespondingAEQualifier));,
            put( "RespondingAPInvocationId", new Integer(XMLRespondingAPInvocationId));,
            put( "RespondingAPTitle", new Integer(XMLRespondingAPTitle));,
            put( "RespondingAuthenticationValue", new Integer(XMLRespondingAuthenticationValue));,
            put( "ResponseAllowed", new Integer(XMLResponseAllowed));,
            put( "Result", new Integer(XMLResult));,
            put( "ResultSourceDiagnostic", new Integer(XMLResultSourceDiagnostic));,
            put( "ReturnParameters", new Integer(XMLReturnParameters));,
            put( "Selector", new Integer(XMLSelector));,
            put( "SenderACSERequirements", new Integer(XMLSenderACSERequirements));,
            put( "Service", new Integer(XMLService));,
            put( "ServiceError", new Integer(XMLServiceError));,
            put( "SetRequest", new Integer(XMLSetRequest));,
            put( "SetRequestNormal", new Integer(XMLSetRequestNormal));,
            put( "SetRequestWithDataBlock", new Integer(XMLSetRequestWithDataBlock));,
            put( "SetRequestWithFirstDataBlock", new Integer(XMLSetRequestWithFirstDataBlock));,
            put( "SetRequestWithList", new Integer(XMLSetRequestWithList));,
            put( "SetRequestWithListAndWithFirstDatablock", new Integer(XMLSetRequestWithListAndWithFirstDatablock));,
            put( "SetResponse", new Integer(XMLSetResponse));,
            put( "SetResponseForDataBlock", new Integer(XMLSetResponseForDataBlock));,
            put( "SetResponseForLastDataBlock", new Integer(XMLSetResponseForLastDataBlock));,
            put( "SetResponseForLastDataBlockWithList", new Integer(XMLSetResponseForLastDataBlockWithList));,
            put( "SetResponseNormal", new Integer(XMLSetResponseNormal));,
            put( "SetResponseWithList", new Integer(XMLSetResponseWithList));,
            put( "Signature", new Integer(XMLSignature));,
            put( "StateError", new Integer(XMLStateError));,
            put( "Structure", new Integer(XMLStructure));,
            put( "Success", new Integer(XMLSuccess));,
            put( "SystemTitle", new Integer(XMLSystemTitle));,
            put( "Task", new Integer(XMLTask));,
            put( "Time", new Integer(XMLTime));,
            put( "TransactionId", new Integer(XMLTransactionId));,
            put( "TypeDescription", new Integer(XMLTypeDescription));,
            put( "UnconfirmedWriteRequest", new Integer(XMLUnconfirmedWriteRequest));,
            put( "Unsigned", new Integer(XMLUnsigned));,
            put( "UserInformation", new Integer(XMLUserInformation));,
            put( "UTF8String", new Integer(XMLUTF8String));,
            put( "VaaName", new Integer(XMLVaaName));,
            put( "Value", new Integer(XMLValue));,
            put( "ValueList", new Integer(XMLValueList));,
            put( "VariableName", new Integer(XMLVariableName));,
            put( "VdeStateError", new Integer(XMLVdeStateError));,
            put( "VisibleString", new Integer(XMLVisibleString));,
            put( "WrappedKey", new Integer(XMLWrappedKey));,
            put( "WriteDataBlockAccess", new Integer(XMLWriteDataBlockAccess));,
            put( "WriteRequest", new Integer(XMLWriteRequest));,
            put( "WriteResponse", new Integer(XMLWriteResponse));
        }};

    }
}
