/*
 * Decompiled with CFR 0.152.
 */
package icube.wrapper;

import icube.wrapper.ICallbacks;
import icube.wrapper.WRAPPERException;
import icube.wrapper.WRAPPERParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public class WRAPPERProtocol {
    private static final int WRAPPERVersion = 1;
    private int clientAddress;
    private int serverAddress;
    private ICallbacks callbacks;
    private InputStream inStream;
    private OutputStream outStream;
    private ByteArrayOutputStream bytesToSend;
    private ByteArrayOutputStream bytesReceived;

    public WRAPPERProtocol(WRAPPERParameters wrapperParameters, InputStream inStream, OutputStream outStream) {
        this.clientAddress = wrapperParameters.ClientAddress;
        this.serverAddress = wrapperParameters.ServerAddress;
        this.callbacks = wrapperParameters.Callbacks;
        this.inStream = inStream;
        this.outStream = outStream;
    }

    public byte[] sendReceive(byte[] outData) throws WRAPPERException, IOException {
        this.bytesToSend = new ByteArrayOutputStream();
        if (this.callbacks != null) {
            this.bytesReceived = new ByteArrayOutputStream();
        }
        this.packWord(1);
        this.packWord(this.clientAddress);
        this.packWord(this.serverAddress);
        this.packWord(outData.length);
        this.bytesToSend.write(outData);
        byte[] bytes = this.bytesToSend.toByteArray();
        this.outStream.write(bytes);
        this.bytesToSend = null;
        if (this.callbacks != null) {
            this.callbacks.onSentStream(bytes);
        }
        this.receiveAndValidateWord(1, "Unexpected wrapper version: ");
        this.receiveAndValidateWord(this.serverAddress, "Unexpected source address: ");
        this.receiveAndValidateWord(this.clientAddress, "Unexpected destination address: ");
        int _length = this.getWord();
        byte[] _bytes = this.readBytes(_length);
        if (this.callbacks != null) {
            this.callbacks.onReceivedStream(this.bytesReceived.toByteArray());
            this.bytesReceived = null;
        }
        return _bytes;
    }

    private void packWord(int word) throws IOException {
        byte[] _bytes = new byte[]{(byte)(word / 255), (byte)(word & 0xFF)};
        this.bytesToSend.write(_bytes);
    }

    private byte[] readBytes(int count) throws IOException, WRAPPERException {
        int _c = count;
        int _o = 0;
        byte[] _bytes = new byte[count];
        try {
            while (_c > 0) {
                int _r = this.inStream.read(_bytes, _o, _c);
                if (_r == -1) {
                    throw new WRAPPERException("Timeout - no response from server");
                }
                _c -= _r;
                _o += _r;
            }
            if (this.callbacks != null) {
                this.bytesReceived.write(_bytes);
            }
        }
        catch (SocketTimeoutException e) {
            throw new WRAPPERException("Timeout - no response from server");
        }
        return _bytes;
    }

    private int getWord() throws IOException, WRAPPERException {
        byte[] _bytes = this.readBytes(2);
        byte _b0 = _bytes[0];
        int _b1 = _bytes[1] & 0xFF;
        return _b0 << 8 | _b1;
    }

    private void receiveAndValidateWord(int word, String message) throws IOException, WRAPPERException {
        int _word = this.getWord();
        if (_word != word) {
            throw new WRAPPERException(String.valueOf(message) + Integer.toString(_word));
        }
    }
}

