/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.auto.XMLIDs;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.XmlPduException;

public class XMLParser {
    static char SPACE = (char)32;
    static char TAB = (char)9;
    static char CR = (char)13;
    static char LF = (char)10;
    static char SLASH = (char)47;
    public static final int xtUnknown = 0;
    public static final int xtStartTag = 1;
    public static final int xtStopTag = 2;
    public static final int xtEndOfBuffer = 3;
    public static final int xtComment = 4;
    public static final int XMLIgnore = 311;
    StringBuffer buffer;
    int nextIdx;
    int lineNr;
    int tokenIdx;
    boolean fullElement;
    StringBuffer tagIdentifier;
    StringBuffer attributeIdentifier;
    StringBuffer attributeValue;
    int attributeId;
    public int token;

    public XMLParser(StringBuffer buffer) throws XmlPduException {
        this.buffer = buffer;
        buffer.append("\u0000");
        this.nextIdx = 0;
        this.lineNr = 0;
        this.tagIdentifier = new StringBuffer();
        this.attributeIdentifier = new StringBuffer();
        this.attributeValue = new StringBuffer();
        this.next();
    }

    void identifier(StringBuffer s) {
        this.tokenIdx = this.nextIdx;
        s.setLength(0);
        while (this.inTagCharacters(this.buffer.charAt(this.nextIdx))) {
            s.append(this.buffer.charAt(this.nextIdx++));
        }
    }

    boolean inTagCharacters(char c) {
        return (c = Character.toUpperCase(c)) >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public boolean isStartTag(int xmlId) throws XmlPduException {
        return this.token == 1 && this.keyword(this.tagIdentifier) == xmlId;
    }

    public boolean isStartTag(int xmlId1, int xmlId2, int xmlId3) throws XmlPduException {
        return this.isStartTag(xmlId1) || this.isStartTag(xmlId2) || this.isStartTag(xmlId3);
    }

    public boolean isStartTag(int xmlId1, int xmlId2, int xmlId3, int xmlId4, int xmlId5) throws XmlPduException {
        return this.isStartTag(xmlId1) || this.isStartTag(xmlId2) || this.isStartTag(xmlId3) || this.isStartTag(xmlId4) || this.isStartTag(xmlId5);
    }

    int keyword(StringBuffer s) throws XmlPduException {
        return XMLIDs.xmlIdToInt(s.toString());
    }

    public void next() throws XmlPduException {
        do {
            char c = this.buffer.charAt(this.nextIdx);
            while (true) {
                if (c == SPACE || c == TAB || c == CR) {
                    ++this.nextIdx;
                } else {
                    if (c != LF) break;
                    ++this.nextIdx;
                    ++this.lineNr;
                }
                c = this.buffer.charAt(this.nextIdx);
            }
            if (c == '<') {
                this.tokenIdx = this.nextIdx++;
                this.proceed();
                continue;
            }
            this.token = c == '\u0000' ? 3 : 0;
        } while (this.token == 4);
    }

    void proceed() throws XmlPduException {
        this.token = 0;
        this.fullElement = false;
        while (true) {
            boolean start;
            if (this.buffer.charAt(this.nextIdx) == SLASH) {
                start = false;
                ++this.nextIdx;
            } else {
                start = true;
            }
            if (!this.inTagCharacters(this.buffer.charAt(this.nextIdx))) break;
            this.identifier(this.tagIdentifier);
            this.whiteSpace();
            if (this.buffer.charAt(this.nextIdx) == '>') {
                this.token = start ? 1 : 2;
                ++this.nextIdx;
                break;
            }
            if (this.inTagCharacters(this.buffer.charAt(this.nextIdx))) {
                this.identifier(this.attributeIdentifier);
                this.attributeId = this.keyword(this.attributeIdentifier);
                this.whiteSpace();
                if (this.buffer.charAt(this.nextIdx) != '=') break;
                ++this.nextIdx;
                this.whiteSpace();
                char c = this.buffer.charAt(this.nextIdx);
                if (c != '\'' && c != '\"') break;
                this.value(c);
                this.whiteSpace();
            }
            if (this.buffer.charAt(this.nextIdx) == '/') {
                ++this.nextIdx;
                this.fullElement = true;
            }
            if (this.buffer.charAt(this.nextIdx) != '>') break;
            ++this.nextIdx;
            if (start) {
                this.token = 1;
                continue;
            }
            this.token = 2;
        }
    }

    public int tag() throws XmlPduException {
        return this.keyword(this.tagIdentifier);
    }

    void value(char Quote) {
        this.tokenIdx = this.nextIdx++;
        this.attributeValue.setLength(0);
        char c = this.buffer.charAt(this.nextIdx);
        while (c != Quote && c != '\u0000') {
            this.attributeValue.append(c);
            ++this.nextIdx;
            c = this.buffer.charAt(this.nextIdx);
        }
        ++this.nextIdx;
    }

    void whiteSpace() {
        char c = this.buffer.charAt(this.nextIdx);
        while (true) {
            if (c != SPACE && c != TAB && c != CR) {
                if (c != LF) break;
                ++this.lineNr;
            }
            ++this.nextIdx;
            c = this.buffer.charAt(this.nextIdx);
        }
    }

    public void XMLAssertStartTag(int xmlId) throws XmlPduException {
        if (this.token != 1 || this.keyword(this.tagIdentifier) != xmlId) {
            throw new XmlPduException("Start tag: " + XMLIDs.xmlIdToStr(xmlId) + " expected");
        }
    }

    public void xmlAssertStartTagAndNext(int xmlId) throws XmlPduException {
        this.XMLAssertStartTag(xmlId);
        this.next();
    }

    public void xmlAssertStopTagAndNext(int xmlId) throws XmlPduException {
        if (this.token != 2 || this.keyword(this.tagIdentifier) != xmlId) {
            throw new XmlPduException("Stop tag: " + XMLIDs.xmlIdToStr(xmlId) + " expected");
        }
        this.next();
    }

    public int xmlGetAttributeIntValue(int attribute) throws XmlPduException {
        return Misc.hexToInt(this.xmlGetAttributeValue(attribute));
    }

    public StringBuffer xmlGetAttributeValue(int attribute) throws XmlPduException {
        if (this.token == 1 && this.attributeId == attribute) {
            return this.attributeValue;
        }
        throw new XmlPduException("\"" + XMLIDs.xmlIdToStr(attribute) + "\" expected");
    }

    public static void illegalAttributeValue(StringBuffer s) throws XmlPduException {
        throw new XmlPduException("Illegal attribute value " + s);
    }

    public static void unexpectedKeyword(int k) throws XmlPduException {
        throw new XmlPduException("Unexpected keyword " + XMLIDs.xmlIdToStr(k));
    }
}

