/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.XmlPduException;
import java.io.ByteArrayOutputStream;

public class ValueBox {
    byte[] data;
    int size;
    int type;
    static final int BOOLEAN = 0;
    static final int SIGNED_INTEGER = 1;
    static final int UNSIGNED_INTEGER = 2;
    static final int FLOAT = 3;

    public ValueBox(int size, int type) {
        this.size = size;
        this.type = type;
        this.data = new byte[size];
    }

    public void setValue(byte[] s) throws XmlPduException {
        if (s.length == this.size) {
            int i = 0;
            while (i < this.size) {
                this.data[i] = s[i];
                ++i;
            }
        } else {
            throw new XmlPduException("ValueBox.setValue");
        }
    }

    public boolean asboolean() {
        return this.data[0] != 0;
    }

    public void setValue(boolean value) {
        this.data[0] = value ? (byte)1 : 0;
    }

    public int asint() {
        int result = 0;
        if (this.type == 1 && (this.data[0] & 0x80) != 0) {
            result = -1;
        }
        int i = 0;
        while (i < this.size) {
            result = (result << 8) + (this.data[i] & 0xFF);
            ++i;
        }
        return result;
    }

    public void setValue(int value) {
        int i = this.size - 1;
        while (i >= 0) {
            this.data[i] = (byte)(value & 0xFF);
            value >>= 8;
            --i;
        }
    }

    public long aslong() {
        long result = 0L;
        int i = 0;
        while (i < this.size) {
            result = (result << 8) + (long)(this.data[i] & 0xFF);
            ++i;
        }
        return result;
    }

    public void setValue(long value) {
        int i = this.size - 1;
        while (i >= 0) {
            this.data[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
    }

    public float asfloat() {
        return Float.intBitsToFloat(this.asint());
    }

    public void setValue(float value) {
        this.setValue(Float.floatToRawIntBits(value));
    }

    public double asdouble() {
        return Double.longBitsToDouble(this.aslong());
    }

    public void setValue(double value) {
        this.setValue(Double.doubleToRawLongBits(value));
    }

    public void toPdu(ByteArrayOutputStream pdu) {
        int i = 0;
        while (i < this.size) {
            pdu.write(this.data[i]);
            ++i;
        }
    }

    public void fromPdu(PduInputStream pdu) throws XmlPduException {
        int i = 0;
        while (i < this.size) {
            this.data[i] = (byte)pdu.ReadByte();
            ++i;
        }
    }

    public StringBuffer toHexStr() {
        return Misc.byteArraytoHexStr(this.data);
    }
}

