/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.TrialWatch;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public abstract class SequenceOf
extends CosemPduBase {
    public CosemPduBase[] elements;

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        Misc.encodeVarLengthUnsignedInteger(pdu, this.elements.length);
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].toPdu(pdu);
            ++i;
        }
    }

    public void SaveToXml(XmlStringBuffer xml, int OfChoice) throws XmlPduException {
        int n = this.elements.length;
        if (n > TrialWatch.MaxSequenceCount) {
            n = TrialWatch.MaxSequenceCount;
        }
        xml.emitTagAttrLine(this.xmlId, 360, Misc.intToHex(n, false), 0);
        xml.incIndent();
        int i = 0;
        while (i < n) {
            CosemPduBase O = this.elements[i];
            if (OfChoice == 1) {
                O.xmlId = 311;
            }
            O.toXml(xml);
            ++i;
        }
        xml.decIndent();
        xml.xmlCloseTagLn(this.xmlId);
    }
}

