/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.XmlPduException;
import java.io.ByteArrayInputStream;

public class PduInputStream
extends ByteArrayInputStream {
    public PduInputStream(byte[] pdu) {
        super(pdu);
    }

    public int ReadByte() throws XmlPduException {
        int b = super.read();
        if (b == -1) {
            throw new XmlPduException("EOS - End Of Stream reached");
        }
        return b;
    }

    public void Expect(int b) throws XmlPduException {
        int n = this.ReadByte();
        if (n != b) {
            throw new XmlPduException("Illegal value " + String.valueOf(b) + " in pdu at pos. " + String.valueOf(this.pos));
        }
    }

    public byte Inspect() throws XmlPduException {
        byte b = (byte)this.ReadByte();
        --this.pos;
        return b;
    }

    public int RemainingBytes() {
        return this.count - this.pos;
    }
}

