/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class OctetString
extends CosemPduBase {
    public byte[] value;
    public int size;

    public void LoadFromXml(XMLParser parser) throws XmlPduException {
        this.value = Misc.formattedStrToByteArray(parser.xmlGetAttributeValue(409));
        if (this.size != -1 && this.value.length != this.size) {
            throw new XmlPduException("OctetString: Illegal data size, expected " + String.valueOf(this.size) + " found " + String.valueOf(this.value.length));
        }
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        int n;
        if (this.size == -1) {
            Misc.encodeVarLengthUnsignedInteger(pdu, this.value.length);
            n = this.value.length;
        } else {
            n = this.size;
        }
        int i = 0;
        while (i < n) {
            pdu.write(this.value[i]);
            ++i;
        }
    }

    public void LoadfromPdu(PduInputStream pdu) throws XmlPduException {
        int n = this.size == -1 ? Misc.decodeVarLengthUnsignedInteger(pdu) : this.size;
        this.value = new byte[n];
        int i = 0;
        while (i < n) {
            this.value[i] = (byte)pdu.ReadByte();
            ++i;
        }
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        xml.emitTagAttrLine(this.xmlId, 409, Misc.byteArrayToFormattedString(this.value), 1);
    }
}

