/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XmlPduException;

public class Misc {
    public static StringBuffer AXDRBitStringToBinHexStr(byte[] bytes, int bitQty) throws XmlPduException {
        int m = 0;
        int nextCharIndex = 0;
        int inByte = 0;
        StringBuffer result = new StringBuffer();
        if (bitQty <= 0 || bytes.length != (bitQty + 7) / 8) {
            throw new XmlPduException("AXDRBitStringToBinHexStr: Illegal byte qty");
        }
        int i = 1;
        while (i <= bitQty) {
            if (m == 0) {
                m = 128;
                inByte = bytes[nextCharIndex++];
            }
            if ((m & inByte) != 0) {
                result.append("1");
            } else {
                result.append("0");
            }
            m >>= 1;
            ++i;
        }
        return result;
    }

    public static byte[] binHexStrToAXDRBitString(StringBuffer binHexStr) throws XmlPduException {
        int outByte = 0;
        int outByteIndex = 0;
        if (binHexStr.length() == 0) {
            throw new XmlPduException("Empty BinHexStr");
        }
        byte[] result = new byte[(binHexStr.length() + 7) / 8];
        int m = 128;
        int i = 0;
        while (i < binHexStr.length()) {
            switch (binHexStr.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    outByte = (byte)(outByte | m);
                    break;
                }
                default: {
                    throw new XmlPduException("Illegal character in BinHexStr");
                }
            }
            if ((m >>= 1) == 0) {
                result[outByteIndex++] = outByte;
                outByte = 0;
                m = 128;
            }
            ++i;
        }
        if (m != 128) {
            result[outByteIndex++] = outByte;
        }
        return result;
    }

    public static StringBuffer byteArraytoHexStr(byte[] s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length) {
            result.append(Misc.toHexChar(s[i] >>> 4 & 0xF));
            result.append(Misc.toHexChar(s[i] & 0xF));
            ++i;
        }
        return result;
    }

    public static String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(Misc.toHexChar(data >>> 4 & 0xF));
        buf.append(Misc.toHexChar(data & 0xF));
        return buf.toString();
    }

    public static StringBuffer decodeBERBitStringHexStr(PduInputStream pdu) throws XmlPduException {
        StringBuffer Result = new StringBuffer();
        int remainder = pdu.ReadByte();
        int unusedInLastByte = pdu.ReadByte();
        --remainder;
        while (remainder > 0) {
            int b = pdu.ReadByte();
            int bitsToProcess = --remainder == 0 ? 8 - unusedInLastByte : 8;
            while (bitsToProcess > 0) {
                if ((b & 0x80) != 0) {
                    Result.append('1');
                } else {
                    Result.append('0');
                }
                b = (b & 0x7F) >> 1;
                --bitsToProcess;
            }
        }
        return Result;
    }

    public static StringBuffer decodeGraphicByteStringStr(PduInputStream pdu) throws XmlPduException {
        int byteQty = pdu.ReadByte();
        StringBuffer Result = new StringBuffer();
        while (byteQty > 0) {
            char c = (char)pdu.ReadByte();
            Result.append(c);
            --byteQty;
        }
        return Result;
    }

    public static StringBuffer decodeObjectStr(PduInputStream pdu, boolean withTag) throws XmlPduException {
        if (withTag) {
            pdu.Expect(6);
        }
        pdu.Expect(7);
        pdu.Expect(96);
        pdu.Expect(133);
        pdu.Expect(116);
        pdu.Expect(5);
        pdu.Expect(8);
        switch (pdu.ReadByte()) {
            case 1: {
                switch (pdu.ReadByte()) {
                    case 1: {
                        return new StringBuffer("LN");
                    }
                    case 2: {
                        return new StringBuffer("SN");
                    }
                }
                throw new XmlPduException("Unknown context name encoding");
            }
            case 2: {
                switch (pdu.ReadByte()) {
                    case 1: {
                        return new StringBuffer("LOW_SECURITY");
                    }
                    case 2: {
                        return new StringBuffer("HIGH_SECURITY");
                    }
                }
                throw new XmlPduException("Unknown mechanism name encoding");
            }
        }
        throw new XmlPduException("Unknown object identifier");
    }

    public static int decodeVarLengthUnsignedInteger(PduInputStream pdu) throws XmlPduException {
        byte b = (byte)pdu.ReadByte();
        if ((b & 0x80) != 0) {
            switch (b & 0x7F) {
                case 1: {
                    return pdu.ReadByte();
                }
                case 2: {
                    int n = pdu.ReadByte();
                    return (n << 8) + pdu.ReadByte();
                }
            }
            throw new XmlPduException("Length " + String.valueOf(b) + " of variable-length integer is not implemented");
        }
        return b;
    }

    public static void encodeBitStringByteStr(StringBuffer data, PduOutputStream pdu, boolean withTag) throws XmlPduException {
        if (withTag) {
            pdu.write(3);
        }
        Misc.packBERBitString(data, pdu);
    }

    public static void encodeGraphicByteStr(StringBuffer data, PduOutputStream pdu, boolean withTag) {
        if (withTag) {
            pdu.write(19);
        }
        pdu.write((byte)data.length());
        int i = 0;
        while (i < data.length()) {
            pdu.write((byte)data.charAt(i));
            ++i;
        }
    }

    public static void encodeObjectByteStr(StringBuffer data, PduOutputStream pdu, boolean withTag) throws XmlPduException {
        if (withTag) {
            pdu.write(6);
        }
        pdu.write(7);
        pdu.write(96);
        pdu.write(-123);
        pdu.write(116);
        pdu.write(5);
        pdu.write(8);
        String s = data.toString();
        if (s.equalsIgnoreCase("LN")) {
            pdu.write(1);
            pdu.write(1);
        } else if (s.equalsIgnoreCase("SN")) {
            pdu.write(1);
            pdu.write(2);
        } else if (s.equalsIgnoreCase("HIGH_SECURITY")) {
            pdu.write(2);
            pdu.write(2);
        } else if (s.equalsIgnoreCase("LOW_SECURITY")) {
            pdu.write(2);
            pdu.write(1);
        } else {
            throw new XmlPduException("Unknown identifier " + s);
        }
    }

    public static void encodeVarLengthUnsignedInteger(PduOutputStream pdu, int value) throws XmlPduException {
        if (value <= 127) {
            pdu.write(value);
        } else if (value <= 255) {
            pdu.write(129);
            pdu.write(value);
        } else if (value <= 65535) {
            pdu.write(130);
            pdu.write(value / 256);
            pdu.write(value % 256);
        } else {
            throw new XmlPduException("Coding of variable-lenght integer " + String.valueOf(value) + " not implemented");
        }
    }

    public static StringBuffer byteArrayToFormattedString(byte[] s) {
        boolean printable = true;
        int i = 0;
        while (printable && i < s.length) {
            printable = s[i] >= 32 && s[i] <= 126 && s[i] != 34 && s[i] != 39;
            ++i;
        }
        if (printable && s.length > 0) {
            StringBuffer result = new StringBuffer();
            result.append('\\');
            i = 0;
            while (i < s.length) {
                result.append((char)s[i]);
                ++i;
            }
            return result;
        }
        return Misc.byteArraytoHexStr(s);
    }

    public static byte[] formattedStrToByteArray(StringBuffer s) throws XmlPduException {
        if (s.length() > 1 && s.charAt(0) == '\\') {
            byte[] result = new byte[s.length() - 1];
            int i = 1;
            while (i < s.length()) {
                result[i - 1] = (byte)s.charAt(i);
                ++i;
            }
            return result;
        }
        return Misc.hexStrToByteArray(s);
    }

    public static byte[] hexStrToByteArray(StringBuffer s) throws XmlPduException {
        byte[] result = new byte[s.length() / 2];
        int i = 0;
        int j = 0;
        int h = 0;
        int k = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                h = (h << 4) + c - 48;
                ++j;
            } else if (c >= 'A' && c <= 'F') {
                h = (h << 4) + c - 65 + 10;
                ++j;
            } else if (c >= 'a' && c <= 'f') {
                h = (h << 4) + c - 97 + 10;
                ++j;
            } else if (c != ' ') {
                throw new XmlPduException("HexStrToByteStr: Illegal character");
            }
            if (j == 2) {
                result[k++] = (byte)h;
                h = 0;
                j = 0;
            }
            ++i;
        }
        return result;
    }

    public static StringBuffer hexStrToVisibleStr(StringBuffer s) throws XmlPduException {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int j = 0;
        int h = 0;
        while (i < s.length()) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') {
                h = (h << 4) + s.charAt(i) - 48;
                ++j;
            } else if (s.charAt(i) >= 'A' && s.charAt(i) <= 'F') {
                h = (h << 4) + s.charAt(i) - 65 + 10;
                ++j;
            } else if (s.charAt(i) != ' ') {
                throw new XmlPduException("HexStrToByteStr: Illegal character");
            }
            if (j == 2) {
                result.append((char)h);
                h = 0;
                j = 0;
            }
            ++i;
        }
        return result;
    }

    public static int hexToInt(StringBuffer s) throws XmlPduException {
        int result = 0;
        int i = 0;
        while (i < s.length()) {
            result <<= 4;
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                result += c - 48;
            } else if (c >= 'A' && c <= 'F') {
                result += c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                result += c - 97 + 10;
            } else {
                throw new XmlPduException("hexToInt: illegal character");
            }
            ++i;
        }
        return result;
    }

    public static StringBuffer intToHex(int n, boolean limitOutput) {
        StringBuffer result = new StringBuffer();
        if (!limitOutput) {
            result.append(Misc.toHexChar(n >>> 12 & 0xF));
            result.append(Misc.toHexChar(n >>> 8 & 0xF));
            result.append(Misc.toHexChar(n >>> 4 & 0xF));
            result.append(Misc.toHexChar(n & 0xF));
        } else {
            if (n >= 256) {
                result.append(Misc.toHexChar(n >>> 12 & 0xF));
                result.append(Misc.toHexChar(n >>> 8 & 0xF));
            }
            result.append(Misc.toHexChar(n >>> 4 & 0xF));
            result.append(Misc.toHexChar(n & 0xF));
        }
        return result;
    }

    public static void packBERBitString(StringBuffer data, PduOutputStream pdu) throws XmlPduException {
        byte[] masks = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        int bitQty = 0;
        int bitQtyInCurrentByte = 0;
        int currentDataByte = 0;
        int start = pdu.size();
        pdu.write(0);
        pdu.write(0);
        int i = 0;
        while (i < data.length()) {
            if (data.charAt(i) == '0' || data.charAt(i) == '1') {
                if (bitQtyInCurrentByte == 8) {
                    pdu.write((byte)currentDataByte);
                    bitQtyInCurrentByte = 0;
                    currentDataByte = 0;
                }
                if (data.charAt(i) == '1') {
                    currentDataByte |= masks[bitQtyInCurrentByte];
                }
                ++bitQtyInCurrentByte;
                ++bitQty;
            } else {
                throw new XmlPduException("packBERBitString: illegal character");
            }
            ++i;
        }
        if (bitQtyInCurrentByte > 0) {
            pdu.write((byte)currentDataByte);
        }
        pdu.setValueAt(start, pdu.size() - start - 1);
        pdu.setValueAt(start + 1, 8 - bitQtyInCurrentByte);
    }

    public static char toHexChar(int i) {
        if (i >= 0 && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    public static StringBuffer visibleStrtoHexStr(StringBuffer s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            result.append(Misc.toHexChar(s.charAt(i) >>> 4 & 0xF));
            result.append(Misc.toHexChar(s.charAt(i) & 0xF));
            ++i;
        }
        return result;
    }
}

