/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class BitStr
extends CosemPduBase {
    public String value;

    public BitStr(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = parser.xmlGetAttributeValue(409).toString();
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        int bitQty = this.value.length();
        int bitQtyInCurrentByte = 0;
        int currentDataByte = 0;
        Misc.encodeVarLengthUnsignedInteger(pdu, bitQty);
        int i = 0;
        while (i < bitQty) {
            if (this.value.charAt(i) == '0' || this.value.charAt(i) == '1') {
                if (bitQtyInCurrentByte == 8) {
                    pdu.write((byte)currentDataByte);
                    bitQtyInCurrentByte = 0;
                    currentDataByte = 0;
                }
                if (this.value.charAt(i) == '1') {
                    currentDataByte |= 128 >> bitQtyInCurrentByte;
                }
                ++bitQtyInCurrentByte;
            } else {
                throw new XmlPduException("BERBitStr: illegal character - ".concat(this.value.substring(i, i)));
            }
            ++i;
        }
        if (bitQtyInCurrentByte > 0) {
            pdu.write(currentDataByte);
        }
    }

    public BitStr(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        int bitQty = Misc.decodeVarLengthUnsignedInteger(pdu);
        StringBuffer s = new StringBuffer();
        int bytesToProcess = (bitQty + 7) / 8;
        int unusedInLastByte = (8 - bitQty % 8) % 8;
        while (bytesToProcess > 0) {
            int b = pdu.ReadByte();
            int bitsToProcess = --bytesToProcess == 0 ? 8 - unusedInLastByte : 8;
            int m = 128;
            while (bitsToProcess > 0) {
                if ((b & m) != 0) {
                    s.append('1');
                } else {
                    s.append('0');
                }
                m >>= 1;
                --bitsToProcess;
            }
        }
        this.value = s.toString();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        xml.emitTagAttrLine(this.xmlId, 409, new StringBuffer(this.value), 1);
    }
}

