/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class BERObjectIdentifier
extends CosemPduBase {
    protected static final int LN = 0;
    protected static final int SN = 1;
    protected static final int LN_WITH_CIPHERING = 2;
    protected static final int SN_WITH_CIPHERING = 3;
    protected static final int NO_SECURITY = 10;
    protected static final int LOW_SECURITY = 11;
    protected static final int HIGH_SECURITY = 12;
    protected static final int HIGH_SECURITY_MD5 = 13;
    protected static final int HIGH_SECURITY_SHA1 = 14;
    protected static final int HIGH_SECURITY_GMAC = 15;
    protected static final int HIGH_SECURITY_SHA256 = 16;
    protected static final int HIGH_SECURITY_ECDSA = 17;
    private static Hashtable<String, Integer> hashTable_ = new Hashtable<String, Integer>(){
        {
            this.put("LN", new Integer(0));
            this.put("SN", new Integer(1));
            this.put("LN_WITH_CIPHERING", new Integer(2));
            this.put("SN_WITH_CIPHERING", new Integer(3));
            this.put("NO_SECURITY", new Integer(10));
            this.put("LOW_SECURITY", new Integer(11));
            this.put("HIGH_SECURITY", new Integer(12));
            this.put("HIGH_SECURITY_MD5", new Integer(13));
            this.put("HIGH_SECURITY_SHA1", new Integer(14));
            this.put("HIGH_SECURITY_GMAC", new Integer(15));
            this.put("HIGH_SECURITY_SHA256", new Integer(16));
            this.put("HIGH_SECURITY_ECDSA", new Integer(17));
        }
    };
    public int value;

    protected static String idToStr(int id) throws XmlPduException {
        String _str = null;
        Enumeration<String> _keys = hashTable_.keys();
        while (_keys.hasMoreElements()) {
            String _key = _keys.nextElement();
            int _value = hashTable_.get(_key);
            if (id != _value) continue;
            _str = _key;
            break;
        }
        if (_str == null) {
            throw new XmlPduException("idToStr: unexpected id");
        }
        return _str;
    }

    public void LoadFromXml(XMLParser parser) throws XmlPduException {
        String s = parser.xmlGetAttributeValue(409).toString();
        try {
            Integer i = hashTable_.get(s);
            this.value = i;
        }
        catch (NullPointerException e) {
            throw new XmlPduException("Object identifier illegal value - ".concat(s.toString()));
        }
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        pdu.write(7);
        pdu.write(96);
        pdu.write(133);
        pdu.write(116);
        pdu.write(5);
        pdu.write(8);
        switch (this.value) {
            case 0: {
                pdu.write(1);
                pdu.write(1);
                break;
            }
            case 1: {
                pdu.write(1);
                pdu.write(2);
                break;
            }
            case 2: {
                pdu.write(1);
                pdu.write(3);
                break;
            }
            case 3: {
                pdu.write(1);
                pdu.write(4);
                break;
            }
            case 10: {
                pdu.write(2);
                pdu.write(0);
                break;
            }
            case 11: {
                pdu.write(2);
                pdu.write(1);
                break;
            }
            case 12: {
                pdu.write(2);
                pdu.write(2);
                break;
            }
            case 13: {
                pdu.write(2);
                pdu.write(3);
                break;
            }
            case 14: {
                pdu.write(2);
                pdu.write(4);
                break;
            }
            case 15: {
                pdu.write(2);
                pdu.write(5);
                break;
            }
            case 16: {
                pdu.write(2);
                pdu.write(6);
                break;
            }
            case 17: {
                pdu.write(2);
                pdu.write(7);
            }
        }
    }

    public void LoadfromPdu(PduInputStream pdu) throws XmlPduException {
        pdu.Expect(7);
        pdu.Expect(96);
        pdu.Expect(133);
        pdu.Expect(116);
        pdu.Expect(5);
        pdu.Expect(8);
        int c1 = pdu.ReadByte();
        int c2 = pdu.ReadByte();
        block0 : switch (c1) {
            case 1: {
                switch (c2) {
                    case 1: {
                        this.value = 0;
                        break block0;
                    }
                    case 2: {
                        this.value = 1;
                        break block0;
                    }
                    case 3: {
                        this.value = 2;
                        break block0;
                    }
                    case 4: {
                        this.value = 3;
                        break block0;
                    }
                }
                throw new XmlPduException("Object identifier illegal value ".concat(Integer.toString(c2)));
            }
            case 2: {
                switch (c2) {
                    case 0: {
                        this.value = 10;
                        break block0;
                    }
                    case 1: {
                        this.value = 11;
                        break block0;
                    }
                    case 2: {
                        this.value = 12;
                        break block0;
                    }
                    case 3: {
                        this.value = 13;
                        break block0;
                    }
                    case 4: {
                        this.value = 14;
                        break block0;
                    }
                    case 5: {
                        this.value = 15;
                        break block0;
                    }
                    case 6: {
                        this.value = 16;
                        break block0;
                    }
                    case 7: {
                        this.value = 17;
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new XmlPduException("Object identifier illegal value " + Integer.toString(c1));
            }
        }
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer(BERObjectIdentifier.idToStr(this.value));
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

