/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.infra;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class BERBitStr
extends CosemPduBase {
    public String value;

    public BERBitStr() {
    }

    public BERBitStr(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = parser.xmlGetAttributeValue(409).toString();
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        int bitQty = 0;
        int bitQtyInCurrentByte = 0;
        int currentDataByte = 0;
        pdu.write(0);
        int lengthIndex = pdu.size() - 1;
        pdu.write(0);
        int i = 0;
        while (i < this.value.length()) {
            if (this.value.charAt(i) == '0' || this.value.charAt(i) == '1') {
                if (bitQtyInCurrentByte == 8) {
                    pdu.write((byte)currentDataByte);
                    bitQtyInCurrentByte = 0;
                    currentDataByte = 0;
                }
                if (this.value.charAt(i) == '1') {
                    currentDataByte |= 128 >> bitQtyInCurrentByte;
                }
                ++bitQtyInCurrentByte;
                ++bitQty;
            } else {
                throw new XmlPduException("BERBitStr: illegal character - ".concat(this.value.substring(i, i)));
            }
            ++i;
        }
        if (bitQtyInCurrentByte > 0) {
            pdu.write(currentDataByte);
        }
        pdu.setValueAt(lengthIndex, pdu.size() - lengthIndex - 1);
        pdu.setValueAt(lengthIndex + 1, 8 - bitQtyInCurrentByte);
    }

    public BERBitStr(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.fromPdu(pdu);
    }

    protected void fromPdu(PduInputStream pdu) throws XmlPduException {
        int bytesToProcess = pdu.ReadByte();
        int unusedInLastByte = pdu.ReadByte();
        --bytesToProcess;
        StringBuffer s = new StringBuffer();
        while (bytesToProcess > 0) {
            int b = pdu.ReadByte();
            int bitsToProcess = --bytesToProcess == 0 ? 8 - unusedInLastByte : 8;
            int m = 128;
            while (bitsToProcess > 0) {
                if ((b & m) != 0) {
                    s.append('1');
                } else {
                    s.append('0');
                }
                m >>= 1;
                --bitsToProcess;
            }
        }
        this.value = s.toString();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        xml.emitTagAttrLine(this.xmlId, 409, new StringBuffer(this.value), 1);
    }
}

