/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _Task
extends CosemPduBase {
    public static final int Other = 0;
    public static final int NoRemoteControl = 1;
    public static final int TiStopped = 2;
    public static final int TiRunning = 3;
    public static final int TiUnusable = 4;
    public int value;

    public _Task(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("NoRemoteControl")) {
            this.value = 1;
        } else if (s.equals("TiStopped")) {
            this.value = 2;
        } else if (s.equals("TiRunning")) {
            this.value = 3;
        } else if (s.equals("TiUnusable")) {
            this.value = 4;
        } else {
            throw new XmlPduException("_Task: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _Task(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("NoRemoteControl");
                break;
            }
            case 2: {
                s.append("TiStopped");
                break;
            }
            case 3: {
                s.append("TiRunning");
                break;
            }
            case 4: {
                s.append("TiUnusable");
                break;
            }
            default: {
                throw new XmlPduException("_Task: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

