/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _Service
extends CosemPduBase {
    public static final int Other = 0;
    public static final int PduSize = 1;
    public static final int ServiceUnsupported = 2;
    public int value;

    public _Service(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("PduSize")) {
            this.value = 1;
        } else if (s.equals("ServiceUnsupported")) {
            this.value = 2;
        } else {
            throw new XmlPduException("_Service: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _Service(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("PduSize");
                break;
            }
            case 2: {
                s.append("ServiceUnsupported");
                break;
            }
            default: {
                throw new XmlPduException("_Service: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

