/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.auto._BERCOSEMpdu;
import icube.xmlpdu.auto._ReleaseResponseReason;
import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _ReleaseResponse
extends CosemPduBase {
    public _ReleaseResponseReason Reason;
    public _BERCOSEMpdu UserInformation;

    public _ReleaseResponse(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.xmlAssertStartTagAndNext(xmlId);
        if (parser.isStartTag(365)) {
            this.Reason = new _ReleaseResponseReason(365, parser);
        }
        if (parser.isStartTag(406)) {
            this.UserInformation = new _BERCOSEMpdu(406, parser);
        }
        parser.xmlAssertStopTagAndNext(xmlId);
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        PduOutputStream tmp = new PduOutputStream();
        PduOutputStream m = new PduOutputStream();
        if (this.Reason != null) {
            tmp.write(128);
            this.Reason.toPdu(tmp);
        }
        if (this.UserInformation != null) {
            m.reset();
            m.write(4);
            this.UserInformation.toPdu(m);
            tmp.write(190);
            Misc.encodeVarLengthUnsignedInteger(tmp, m.size());
            tmp.append(m);
        }
        Misc.encodeVarLengthUnsignedInteger(pdu, tmp.size());
        pdu.append(tmp);
    }

    public _ReleaseResponse(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        int TotalLen = Misc.decodeVarLengthUnsignedInteger(pdu);
        while (pdu.RemainingBytes() > 0) {
            int Tag1 = pdu.ReadByte();
            switch (Tag1) {
                case 128: {
                    this.Reason = new _ReleaseResponseReason(365, pdu);
                    break;
                }
                case 190: {
                    int Tag1Length = Misc.decodeVarLengthUnsignedInteger(pdu);
                    int Tag2 = pdu.ReadByte();
                    if (Tag2 != 4) {
                        throw new XmlPduException("_ReleaseResponse: Unexpected tag2 " + String.valueOf(Tag2));
                    }
                    this.UserInformation = new _BERCOSEMpdu(406, pdu);
                    break;
                }
                default: {
                    throw new XmlPduException("_ReleaseResponse: Unexpected tag1 " + String.valueOf(Tag1));
                }
            }
        }
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        xml.xmlOpenTagLn(this.xmlId);
        xml.incIndent();
        if (this.Reason != null) {
            this.Reason.toXml(xml);
        }
        if (this.UserInformation != null) {
            this.UserInformation.toXml(xml);
        }
        xml.decIndent();
        xml.xmlCloseTagLn(this.xmlId);
    }
}

