/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _ReleaseRequestReason
extends CosemPduBase {
    public static final int Normal = 0;
    public static final int Urgent = 1;
    public static final int UserDefined = 30;
    public int value;

    public _ReleaseRequestReason(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Normal")) {
            this.value = 0;
        } else if (s.equals("Urgent")) {
            this.value = 1;
        } else if (s.equals("UserDefined")) {
            this.value = 30;
        } else {
            throw new XmlPduException("_ReleaseRequestReason: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write(1);
        pdu.write((byte)this.value);
    }

    public _ReleaseRequestReason(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        pdu.Expect(1);
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Normal");
                break;
            }
            case 1: {
                s.append("Urgent");
                break;
            }
            case 30: {
                s.append("UserDefined");
                break;
            }
            default: {
                throw new XmlPduException("_ReleaseRequestReason: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

