/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _LoadDataSet
extends CosemPduBase {
    public static final int Other = 0;
    public static final int PrimitiveOutOfSequence = 1;
    public static final int NotLoadable = 2;
    public static final int DatasetSizeTooLarge = 3;
    public static final int NotAwaitedSegment = 4;
    public static final int InterpretationFailure = 5;
    public static final int StorageFailure = 6;
    public static final int DataSetNotReady = 7;
    public int value;

    public _LoadDataSet(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("PrimitiveOutOfSequence")) {
            this.value = 1;
        } else if (s.equals("NotLoadable")) {
            this.value = 2;
        } else if (s.equals("DatasetSizeTooLarge")) {
            this.value = 3;
        } else if (s.equals("NotAwaitedSegment")) {
            this.value = 4;
        } else if (s.equals("InterpretationFailure")) {
            this.value = 5;
        } else if (s.equals("StorageFailure")) {
            this.value = 6;
        } else if (s.equals("DataSetNotReady")) {
            this.value = 7;
        } else {
            throw new XmlPduException("_LoadDataSet: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _LoadDataSet(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("PrimitiveOutOfSequence");
                break;
            }
            case 2: {
                s.append("NotLoadable");
                break;
            }
            case 3: {
                s.append("DatasetSizeTooLarge");
                break;
            }
            case 4: {
                s.append("NotAwaitedSegment");
                break;
            }
            case 5: {
                s.append("InterpretationFailure");
                break;
            }
            case 6: {
                s.append("StorageFailure");
                break;
            }
            case 7: {
                s.append("DataSetNotReady");
                break;
            }
            default: {
                throw new XmlPduException("_LoadDataSet: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

