/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.auto._AgreedKey;
import icube.xmlpdu.auto._IdentifiedKey;
import icube.xmlpdu.auto._WrappedKey;
import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _KeyInfo
extends CosemPduBase {
    int tag;
    CosemPduBase value;

    public _KeyInfo() {
    }

    public _KeyInfo(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        if (xmlId != 311) {
            parser.xmlAssertStartTagAndNext(xmlId);
        }
        if (parser.isStartTag(310)) {
            this.tag = 0;
            this.value = new _IdentifiedKey(310, parser);
        } else if (parser.isStartTag(414)) {
            this.tag = 1;
            this.value = new _WrappedKey(414, parser);
        } else if (parser.isStartTag(207)) {
            this.tag = 2;
            this.value = new _AgreedKey(207, parser);
        } else {
            throw new XmlPduException("_KeyInfo: illegal choice");
        }
        if (xmlId != 311) {
            parser.xmlAssertStopTagAndNext(xmlId);
        }
    }

    public _KeyInfo(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.FromPdu(pdu);
    }

    public void FromPdu(PduInputStream pdu) throws XmlPduException {
        this.tag = pdu.ReadByte();
        switch (this.tag) {
            case 0: {
                this.value = new _IdentifiedKey(310, pdu);
                break;
            }
            case 1: {
                this.value = new _WrappedKey(414, pdu);
                break;
            }
            case 2: {
                this.value = new _AgreedKey(207, pdu);
                break;
            }
            default: {
                throw new XmlPduException("_KeyInfo (from pdu) : illegal tag " + String.valueOf(this.tag));
            }
        }
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        pdu.write((byte)this.tag);
        this.value.toPdu(pdu);
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        if (this.xmlId != 311) {
            xml.xmlOpenTagLn(this.xmlId);
            xml.incIndent();
            this.value.toXml(xml);
            xml.decIndent();
            xml.xmlCloseTagLn(this.xmlId);
        } else {
            this.value.toXml(xml);
        }
    }
}

