/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _KeyId
extends CosemPduBase {
    public static final int GlobalUnicastEncryptionKey = 0;
    public static final int GlobalBroadcastEncryptionKey = 1;
    public int value;

    public _KeyId(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("GlobalUnicastEncryptionKey")) {
            this.value = 0;
        } else if (s.equals("GlobalBroadcastEncryptionKey")) {
            this.value = 1;
        } else {
            throw new XmlPduException("_KeyId: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _KeyId(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("GlobalUnicastEncryptionKey");
                break;
            }
            case 1: {
                s.append("GlobalBroadcastEncryptionKey");
                break;
            }
            default: {
                throw new XmlPduException("_KeyId: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

