/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _HardwareResource
extends CosemPduBase {
    public static final int Other = 0;
    public static final int MemoryUnavailable = 1;
    public static final int ProcessorResourceUnavailable = 2;
    public static final int MassStorageUnavailable = 3;
    public static final int OtherResourceUnavailable = 4;
    public int value;

    public _HardwareResource(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("MemoryUnavailable")) {
            this.value = 1;
        } else if (s.equals("ProcessorResourceUnavailable")) {
            this.value = 2;
        } else if (s.equals("MassStorageUnavailable")) {
            this.value = 3;
        } else if (s.equals("OtherResourceUnavailable")) {
            this.value = 4;
        } else {
            throw new XmlPduException("_HardwareResource: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _HardwareResource(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("MemoryUnavailable");
                break;
            }
            case 2: {
                s.append("ProcessorResourceUnavailable");
                break;
            }
            case 3: {
                s.append("MassStorageUnavailable");
                break;
            }
            case 4: {
                s.append("OtherResourceUnavailable");
                break;
            }
            default: {
                throw new XmlPduException("_HardwareResource: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

