/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.ValueBox;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _Float32
extends CosemPduBase {
    public float Value;

    public _Float32(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        byte[] s = Misc.hexStrToByteArray(parser.xmlGetAttributeValue(409));
        if (s.length != 4) {
            throw new XmlPduException("Illegal data size, expected " + String.valueOf(4) + " ,found " + String.valueOf(s.length));
        }
        ValueBox valueBox = new ValueBox(4, 3);
        valueBox.setValue(s);
        this.Value = valueBox.asfloat();
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        ValueBox valueBox = new ValueBox(4, 3);
        valueBox.setValue(this.Value);
        valueBox.toPdu(pdu);
    }

    public _Float32(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        ValueBox valueBox = new ValueBox(4, 3);
        valueBox.fromPdu(pdu);
        this.Value = valueBox.asfloat();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        ValueBox valueBox = new ValueBox(4, 3);
        valueBox.setValue(this.Value);
        xml.emitTagAttrLine(this.xmlId, 409, valueBox.toHexStr(), 1);
    }
}

