/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _DataAccessResult
extends CosemPduBase {
    public static final int Success = 0;
    public static final int HardwareFault = 1;
    public static final int TemporaryFailure = 2;
    public static final int ReadWriteDenied = 3;
    public static final int ObjectUndefined = 4;
    public static final int ObjectClassInconsistent = 9;
    public static final int ObjectUnavailable = 11;
    public static final int TypeUnmatched = 12;
    public static final int ScopeOfAccessViolated = 13;
    public static final int DataBlockUnavailable = 14;
    public static final int LongGetOrReadAborted = 15;
    public static final int NoLongGetOrReadInProgress = 16;
    public static final int LongSetOrWriteAborted = 17;
    public static final int NoLongSetOrWriteInProgress = 18;
    public static final int DataBlockNumberInvalid = 19;
    public static final int OtherReason = 250;
    public int value;

    public _DataAccessResult(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Success")) {
            this.value = 0;
        } else if (s.equals("HardwareFault")) {
            this.value = 1;
        } else if (s.equals("TemporaryFailure")) {
            this.value = 2;
        } else if (s.equals("ReadWriteDenied")) {
            this.value = 3;
        } else if (s.equals("ObjectUndefined")) {
            this.value = 4;
        } else if (s.equals("ObjectClassInconsistent")) {
            this.value = 9;
        } else if (s.equals("ObjectUnavailable")) {
            this.value = 11;
        } else if (s.equals("TypeUnmatched")) {
            this.value = 12;
        } else if (s.equals("ScopeOfAccessViolated")) {
            this.value = 13;
        } else if (s.equals("DataBlockUnavailable")) {
            this.value = 14;
        } else if (s.equals("LongGetOrReadAborted")) {
            this.value = 15;
        } else if (s.equals("NoLongGetOrReadInProgress")) {
            this.value = 16;
        } else if (s.equals("LongSetOrWriteAborted")) {
            this.value = 17;
        } else if (s.equals("NoLongSetOrWriteInProgress")) {
            this.value = 18;
        } else if (s.equals("DataBlockNumberInvalid")) {
            this.value = 19;
        } else if (s.equals("OtherReason")) {
            this.value = 250;
        } else {
            throw new XmlPduException("_DataAccessResult: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _DataAccessResult(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Success");
                break;
            }
            case 1: {
                s.append("HardwareFault");
                break;
            }
            case 2: {
                s.append("TemporaryFailure");
                break;
            }
            case 3: {
                s.append("ReadWriteDenied");
                break;
            }
            case 4: {
                s.append("ObjectUndefined");
                break;
            }
            case 9: {
                s.append("ObjectClassInconsistent");
                break;
            }
            case 11: {
                s.append("ObjectUnavailable");
                break;
            }
            case 12: {
                s.append("TypeUnmatched");
                break;
            }
            case 13: {
                s.append("ScopeOfAccessViolated");
                break;
            }
            case 14: {
                s.append("DataBlockUnavailable");
                break;
            }
            case 15: {
                s.append("LongGetOrReadAborted");
                break;
            }
            case 16: {
                s.append("NoLongGetOrReadInProgress");
                break;
            }
            case 17: {
                s.append("LongSetOrWriteAborted");
                break;
            }
            case 18: {
                s.append("NoLongSetOrWriteInProgress");
                break;
            }
            case 19: {
                s.append("DataBlockNumberInvalid");
                break;
            }
            case 250: {
                s.append("OtherReason");
                break;
            }
            default: {
                throw new XmlPduException("_DataAccessResult: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

