/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.BERBitStr;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _Conformance
extends BERBitStr {
    int bitXMLId;

    public _Conformance(int xmlId, XMLParser parser) throws XmlPduException {
        StringBuffer s;
        int k;
        this.xmlId = xmlId;
        this.bitXMLId = 241;
        boolean[] bits = new boolean[24];
        int tag = parser.tag();
        parser.next();
        while (parser.token == 1) {
            k = parser.tag();
            if (k == this.bitXMLId) {
                s = parser.xmlGetAttributeValue(340);
                int b = this.NameToVal(s.toString());
                bits[b] = true;
                parser.next();
                continue;
            }
            XMLParser.unexpectedKeyword(k);
        }
        parser.xmlAssertStopTagAndNext(tag);
        s = new StringBuffer();
        k = 0;
        while (k < 24) {
            if (bits[k]) {
                s.append("1");
            } else {
                s.append("0");
            }
            ++k;
        }
        this.value = s.toString();
    }

    @Override
    public void toPdu(PduOutputStream pdu) throws XmlPduException {
        pdu.write(95);
        pdu.write(31);
        super.toPdu(pdu);
    }

    public _Conformance(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.bitXMLId = 241;
        pdu.Expect(95);
        if (pdu.Inspect() == 31) {
            pdu.ReadByte();
        }
        this.fromPdu(pdu);
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        xml.xmlOpenTagLn(this.xmlId);
        xml.incIndent();
        int i = 23;
        while (i >= 0) {
            if (this.value.charAt(i) == '1') {
                xml.emitTagAttrLine(241, 340, new StringBuffer(this.ValToName(i)), 1);
            }
            --i;
        }
        xml.decIndent();
        xml.xmlCloseTagLn(this.xmlId);
    }

    String ValToName(int n) throws XmlPduException {
        String s;
        if (n == 0) {
            s = "Reserved0";
        } else if (n == 1) {
            s = "GeneralProtection";
        } else if (n == 2) {
            s = "GeneralBlockTransfer";
        } else if (n == 3) {
            s = "Read";
        } else if (n == 4) {
            s = "Write";
        } else if (n == 5) {
            s = "UnconfirmedWrite";
        } else if (n == 6) {
            s = "Reserved6";
        } else if (n == 7) {
            s = "Reserved7";
        } else if (n == 8) {
            s = "Attribute0SupportedWithSet";
        } else if (n == 9) {
            s = "PriorityMgmtSupported";
        } else if (n == 10) {
            s = "Attribute0SupportedWithGet";
        } else if (n == 10) {
            s = "Attribute0Supported";
        } else if (n == 11) {
            s = "BlockTransferWithGetOrRead";
        } else if (n == 11) {
            s = "BlockTransferWithGet";
        } else if (n == 12) {
            s = "BlockTransferWithSetOrWrite";
        } else if (n == 12) {
            s = "BlockTransferWithSet";
        } else if (n == 13) {
            s = "BlockTransferWithAction";
        } else if (n == 14) {
            s = "MultipleReferences";
        } else if (n == 15) {
            s = "InformationReport";
        } else if (n == 16) {
            s = "DataNotification";
        } else if (n == 17) {
            s = "Access";
        } else if (n == 18) {
            s = "ParametrizedAccess";
        } else if (n == 19) {
            s = "Get";
        } else if (n == 20) {
            s = "Set";
        } else if (n == 21) {
            s = "SelectiveAccess";
        } else if (n == 22) {
            s = "EventNotification";
        } else if (n == 23) {
            s = "Action";
        } else {
            throw new XmlPduException("_Conformance:ValToName, illegal value " + String.valueOf(n));
        }
        return s;
    }

    int NameToVal(String s) throws XmlPduException {
        int n;
        if (s.equals("Reserved0")) {
            n = 0;
        } else if (s.equals("GeneralProtection")) {
            n = 1;
        } else if (s.equals("GeneralBlockTransfer")) {
            n = 2;
        } else if (s.equals("Read")) {
            n = 3;
        } else if (s.equals("Write")) {
            n = 4;
        } else if (s.equals("UnconfirmedWrite")) {
            n = 5;
        } else if (s.equals("Reserved6")) {
            n = 6;
        } else if (s.equals("Reserved7")) {
            n = 7;
        } else if (s.equals("Attribute0SupportedWithSet")) {
            n = 8;
        } else if (s.equals("PriorityMgmtSupported")) {
            n = 9;
        } else if (s.equals("Attribute0SupportedWithGet")) {
            n = 10;
        } else if (s.equals("Attribute0Supported")) {
            n = 10;
        } else if (s.equals("BlockTransferWithGetOrRead")) {
            n = 11;
        } else if (s.equals("BlockTransferWithGet")) {
            n = 11;
        } else if (s.equals("BlockTransferWithSetOrWrite")) {
            n = 12;
        } else if (s.equals("BlockTransferWithSet")) {
            n = 12;
        } else if (s.equals("BlockTransferWithAction")) {
            n = 13;
        } else if (s.equals("MultipleReferences")) {
            n = 14;
        } else if (s.equals("InformationReport")) {
            n = 15;
        } else if (s.equals("DataNotification")) {
            n = 16;
        } else if (s.equals("Access")) {
            n = 17;
        } else if (s.equals("ParametrizedAccess")) {
            n = 18;
        } else if (s.equals("Get")) {
            n = 19;
        } else if (s.equals("Set")) {
            n = 20;
        } else if (s.equals("SelectiveAccess")) {
            n = 21;
        } else if (s.equals("EventNotification")) {
            n = 22;
        } else if (s.equals("Action")) {
            n = 23;
        } else {
            throw new XmlPduException("_Conformance:NameToVal, no such name " + s);
        }
        return n;
    }
}

