/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _ApplicationReference
extends CosemPduBase {
    public static final int Other = 0;
    public static final int TimeElapsed = 1;
    public static final int ApplicationUnreachable = 2;
    public static final int ApplicationReferenceInvalid = 3;
    public static final int ApplicationContextUnsupported = 4;
    public static final int ProviderCommunicationError = 5;
    public static final int DecipheringError = 6;
    public int value;

    public _ApplicationReference(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("TimeElapsed")) {
            this.value = 1;
        } else if (s.equals("ApplicationUnreachable")) {
            this.value = 2;
        } else if (s.equals("ApplicationReferenceInvalid")) {
            this.value = 3;
        } else if (s.equals("ApplicationContextUnsupported")) {
            this.value = 4;
        } else if (s.equals("ProviderCommunicationError")) {
            this.value = 5;
        } else if (s.equals("DecipheringError")) {
            this.value = 6;
        } else {
            throw new XmlPduException("_ApplicationReference: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _ApplicationReference(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("TimeElapsed");
                break;
            }
            case 2: {
                s.append("ApplicationUnreachable");
                break;
            }
            case 3: {
                s.append("ApplicationReferenceInvalid");
                break;
            }
            case 4: {
                s.append("ApplicationContextUnsupported");
                break;
            }
            case 5: {
                s.append("ProviderCommunicationError");
                break;
            }
            case 6: {
                s.append("DecipheringError");
                break;
            }
            default: {
                throw new XmlPduException("_ApplicationReference: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

