/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _Access
extends CosemPduBase {
    public static final int Other = 0;
    public static final int ScopeOfAccessViolated = 1;
    public static final int ObjectAccessInvalid = 2;
    public static final int HardwareFault = 3;
    public static final int ObjectUnavailable = 4;
    public int value;

    public _Access(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        String s = parser.xmlGetAttributeValue(409).toString();
        if (s.equals("Other")) {
            this.value = 0;
        } else if (s.equals("ScopeOfAccessViolated")) {
            this.value = 1;
        } else if (s.equals("ObjectAccessInvalid")) {
            this.value = 2;
        } else if (s.equals("HardwareFault")) {
            this.value = 3;
        } else if (s.equals("ObjectUnavailable")) {
            this.value = 4;
        } else {
            throw new XmlPduException("_Access: illegal element " + s);
        }
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        pdu.write((byte)this.value);
    }

    public _Access(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        this.value = pdu.ReadByte();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        StringBuffer s = new StringBuffer();
        switch (this.value) {
            case 0: {
                s.append("Other");
                break;
            }
            case 1: {
                s.append("ScopeOfAccessViolated");
                break;
            }
            case 2: {
                s.append("ObjectAccessInvalid");
                break;
            }
            case 3: {
                s.append("HardwareFault");
                break;
            }
            case 4: {
                s.append("ObjectUnavailable");
                break;
            }
            default: {
                throw new XmlPduException("_Access: case range");
            }
        }
        xml.emitTagAttrLine(this.xmlId, 409, s, 1);
    }
}

