/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu.auto;

import icube.xmlpdu.infra.CosemPduBase;
import icube.xmlpdu.infra.Misc;
import icube.xmlpdu.infra.PduInputStream;
import icube.xmlpdu.infra.PduOutputStream;
import icube.xmlpdu.infra.ValueBox;
import icube.xmlpdu.infra.XMLParser;
import icube.xmlpdu.infra.XmlPduException;
import icube.xmlpdu.infra.XmlStringBuffer;

public class _ACSEServiceProvider
extends CosemPduBase {
    public int Value;

    public _ACSEServiceProvider(int xmlId, XMLParser parser) throws XmlPduException {
        this.xmlId = xmlId;
        parser.XMLAssertStartTag(xmlId);
        byte[] s = Misc.hexStrToByteArray(parser.xmlGetAttributeValue(409));
        if (s.length != 1) {
            throw new XmlPduException("Illegal data size, expected: 1 ,found: " + String.valueOf(s.length));
        }
        ValueBox valueBox = new ValueBox(1, 2);
        valueBox.setValue(s);
        this.Value = valueBox.asint();
        parser.next();
    }

    @Override
    public void toPdu(PduOutputStream pdu) {
        ValueBox valueBox = new ValueBox(1, 2);
        valueBox.setValue(this.Value);
        pdu.write(1);
        valueBox.toPdu(pdu);
    }

    public _ACSEServiceProvider(int xmlId, PduInputStream pdu) throws XmlPduException {
        this.xmlId = xmlId;
        int length = pdu.ReadByte();
        if (length != 1) {
            throw new XmlPduException("_ACSEServiceProvider: Illegal data size, expected:1 ,found " + String.valueOf(length));
        }
        ValueBox valueBox = new ValueBox(1, 2);
        valueBox.fromPdu(pdu);
        this.Value = valueBox.asint();
    }

    @Override
    public void toXml(XmlStringBuffer xml) throws XmlPduException {
        ValueBox valueBox = new ValueBox(1, 2);
        valueBox.setValue(this.Value);
        xml.emitTagAttrLine(this.xmlId, 409, valueBox.toHexStr(), 1);
    }
}

