/*
 * Decompiled with CFR 0.152.
 */
package icube.xmlpdu;

import icube.xmlpdu.XmlPduInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class TestXmlPdu {
    static char CR = (char)13;
    static char LF = (char)10;

    static void ConsoleWriteLine(String s) {
        System.out.println(s);
    }

    static void ConsoleReadKey() throws IOException {
        System.in.read();
    }

    public static int HexCharToValue(char c) {
        if (c >= '0' && c <= '9') {
            return Character.getNumericValue(c) - Character.getNumericValue('0');
        }
        return Character.getNumericValue(c) - Character.getNumericValue('A') + 10;
    }

    public static byte[] HexStringToBytes(String s) throws Exception {
        if ((s.length() & 1) == 1) {
            throw new Exception("The length of the string must be a multiple of 2.");
        }
        byte[] _bytes = new byte[s.length() >> 1];
        int i = 0;
        while (i < s.length()) {
            int _highNibble = TestXmlPdu.HexCharToValue(s.charAt(i));
            int _lowNibble = TestXmlPdu.HexCharToValue(s.charAt(i + 1));
            if (_highNibble == -1 || _lowNibble == -1) {
                throw new Exception("Invalid digit.");
            }
            _bytes[i >> 1] = (byte)(_highNibble << 4 | _lowNibble);
            i += 2;
        }
        return _bytes;
    }

    public static String BytesToHexString(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        byte[] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return sb.toString();
    }

    static boolean EqualXml(StringBuffer xml1, StringBuffer xml2) {
        int n2;
        while (xml1.charAt(0) != '<') {
            xml1.deleteCharAt(0);
        }
        while (xml2.charAt(0) != '<') {
            xml2.deleteCharAt(0);
        }
        while (xml1.charAt(xml1.length() - 1) != '>') {
            xml1.deleteCharAt(xml1.length() - 1);
        }
        while (xml2.charAt(xml2.length() - 1) != '>') {
            xml2.deleteCharAt(xml2.length() - 1);
        }
        String s1 = xml1.toString();
        String s2 = xml2.toString();
        int n1 = s1.length();
        if (n1 != (n2 = s2.length())) {
            return false;
        }
        int i = 0;
        while (i < s1.length()) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return s1.equals(s2);
    }

    static void DoOne(StringBuffer xml, String pdu) throws Exception {
        String s = xml.toString();
        byte[] cpdu = XmlPduInterface.XmlToPdu(xml);
        s = TestXmlPdu.BytesToHexString(cpdu);
        if (!s.equals(pdu)) {
            TestXmlPdu.ConsoleWriteLine("*** PDU mismatch");
            TestXmlPdu.ConsoleWriteLine(xml.toString());
            TestXmlPdu.ConsoleWriteLine("E: " + pdu);
            TestXmlPdu.ConsoleWriteLine("F: " + s);
            TestXmlPdu.ConsoleWriteLine("");
            throw new Exception("");
        }
        StringBuffer cxml = XmlPduInterface.PduToXml(cpdu);
        if (!TestXmlPdu.EqualXml(xml, cxml)) {
            TestXmlPdu.ConsoleWriteLine("*** XML mismatch");
            TestXmlPdu.ConsoleWriteLine("Expected:");
            TestXmlPdu.ConsoleWriteLine(xml.toString());
            TestXmlPdu.ConsoleWriteLine("");
            TestXmlPdu.ConsoleWriteLine("Found:");
            TestXmlPdu.ConsoleWriteLine(cxml.toString());
            TestXmlPdu.ConsoleWriteLine("");
            throw new Exception("XML mismatch");
        }
    }

    static void ProcessFile(String FilePath) throws Exception {
        String line2 = "";
        File file = new File(FilePath);
        FileReader fileReader = new FileReader(file);
        BufferedReader InFile = new BufferedReader(fileReader);
        StringBuffer xml = new StringBuffer();
        Boolean Continue = true;
        TestXmlPdu.ConsoleWriteLine("Processing: " + FilePath);
        String line = InFile.readLine();
        while (line != null) {
            xml.setLength(0);
            while (line != null && Continue.booleanValue()) {
                if (line.charAt(0) == '#') {
                    line2 = line;
                    break;
                }
                xml.append(CR);
                xml.append(LF);
                xml.append(line);
                line = InFile.readLine();
            }
            String pdu = InFile.readLine();
            try {
                TestXmlPdu.DoOne(xml, pdu);
            }
            catch (Exception e) {
                TestXmlPdu.ConsoleWriteLine(line2);
                TestXmlPdu.ConsoleWriteLine(xml.toString());
                TestXmlPdu.ConsoleWriteLine(e.toString());
                throw e;
            }
            line = InFile.readLine();
            line = InFile.readLine();
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            TestXmlPdu.ProcessFile("src/icube/xmlpdu/One.txt");
            TestXmlPdu.ProcessFile("src/icube/xmlpdu/CTT_Debug1.txt");
            TestXmlPdu.ProcessFile("src/icube/xmlpdu/CTT_Debug2.txt");
            TestXmlPdu.ProcessFile("src/icube/xmlpdu/CTT_Debug3.txt");
            TestXmlPdu.ProcessFile("src/icube/xmlpdu/CTT_Debug4.txt");
        }
        catch (Exception e) {
            TestXmlPdu.ConsoleWriteLine(e.toString());
        }
        TestXmlPdu.ConsoleWriteLine("Done hit ENTER !!!");
        TestXmlPdu.ConsoleReadKey();
    }
}

