/*
 * Decompiled with CFR 0.152.
 */
package icube.ezhdlc;

import icube.ezhdlc.EzHdlcException;
import icube.ezhdlc.Frame;
import icube.ezhdlc.FrameAddress;
import icube.ezhdlc.HDLCParameters;
import icube.ezhdlc.HDLCProtocolState;
import icube.ezhdlc.ICallbacks;
import icube.ezhdlc.TrialWatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public final class HDLCProtocol {
    private final int DefaultWindowSize = 1;
    private final int DefaultInfoFieldLength = 128;
    private final int RecoveryMaxRetry = 5;
    private final byte GBTTag = (byte)-32;
    private ICallbacks callbacks_;
    private FrameAddress localAddress_;
    private FrameAddress remoteAddress_;
    private HDLCProtocolState state_;
    private int maxInfoFieldLengthTransmit_;
    private int maxInfoFieldLengthReceive_;
    private int windowSizeTransmit_;
    private int windowSizeReceive_;
    private byte SSN;
    private byte RSN;
    private byte[] LLCRequestPrefix;
    private byte[] LLCResponsePrefix;
    private InputStream inStream_;
    private OutputStream outStream_;

    private void setState(HDLCProtocolState state) {
        if (this.state_ != state) {
            this.state_ = state;
            if (this.callbacks_ != null) {
                this.callbacks_.onStateChange(this.state_);
            }
        }
    }

    public HDLCProtocolState getState() {
        return this.state_;
    }

    public HDLCProtocol(HDLCParameters hdlcParameters, InputStream inStream, OutputStream outStream) {
        byte[] byArray = new byte[3];
        byArray[0] = -26;
        byArray[1] = -26;
        this.LLCRequestPrefix = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = -26;
        byArray2[1] = -25;
        this.LLCResponsePrefix = byArray2;
        this.state_ = HDLCProtocolState.NDM;
        this.inStream_ = inStream;
        this.outStream_ = outStream;
        this.localAddress_ = new FrameAddress(hdlcParameters.ClientMACAddress, 0, 1);
        this.remoteAddress_ = new FrameAddress(hdlcParameters.ServerUpperMACAddressValue, hdlcParameters.ServerLowerMACAddressValue, hdlcParameters.ServerAddressSize);
        this.callbacks_ = hdlcParameters.Callbacks;
    }

    public void connect() throws EzHdlcException, IOException {
        TrialWatch.CheckTimeover();
        Frame _frame = new Frame();
        _frame.Kind = Frame.FrameKind.SNRM;
        _frame.SrcAddress = this.localAddress_;
        _frame.DstAddress = this.remoteAddress_;
        _frame.PollFinal = true;
        byte[] _response = this.sendReceiveBytes(_frame.getPDUByteStream());
        if (_response.length == 0) {
            this.throwHDLCException("No response to SNRM");
        }
        _frame.setFromPduByteStr(_response);
        if (_frame.Kind == Frame.FrameKind.UA) {
            this.maxInfoFieldLengthTransmit_ = 128;
            this.maxInfoFieldLengthReceive_ = 128;
            this.windowSizeTransmit_ = 1;
            this.windowSizeReceive_ = 1;
            if (_frame.Data != null) {
                ByteArrayInputStream _frameData = new ByteArrayInputStream(_frame.Data);
                _frameData.skip(3L);
                while (_frameData.available() != 0) {
                    switch (_frameData.read()) {
                        case 5: {
                            this.maxInfoFieldLengthReceive_ = this.readDataInteger(_frameData);
                            break;
                        }
                        case 6: {
                            this.maxInfoFieldLengthTransmit_ = this.readDataInteger(_frameData);
                            break;
                        }
                        case 7: {
                            this.windowSizeReceive_ = this.readDataInteger(_frameData);
                            break;
                        }
                        case 8: {
                            this.windowSizeTransmit_ = this.readDataInteger(_frameData);
                            break;
                        }
                        default: {
                            this.throwHDLCException("Illegal UA data");
                        }
                    }
                }
            }
            this.RSN = 0;
            this.SSN = 0;
            this.setState(HDLCProtocolState.NRM);
        } else {
            this.throwHDLCException("Unexpected response to SNRM frame");
        }
    }

    public void disconnect() throws EzHdlcException, IOException {
        Frame _frame = new Frame();
        _frame.Kind = Frame.FrameKind.DISC;
        _frame.SrcAddress = this.localAddress_;
        _frame.DstAddress = this.remoteAddress_;
        _frame.PollFinal = true;
        byte[] _response = this.sendReceiveBytes(_frame.getPDUByteStream());
        this.setState(HDLCProtocolState.NDM);
    }

    private int readDataInteger(ByteArrayInputStream s) {
        int _res = 0;
        switch (s.read()) {
            case 1: {
                _res = s.read();
                break;
            }
            case 2: {
                _res = (s.read() << 8) + s.read();
                break;
            }
            case 4: {
                _res = (s.read() << 24) + (s.read() << 16) + (s.read() << 8) + s.read();
            }
        }
        return _res;
    }

    public void poll() throws EzHdlcException, IOException {
        Frame _frame = new Frame();
        _frame.Kind = Frame.FrameKind.RR;
        _frame.Segmented = false;
        _frame.SrcAddress = this.localAddress_;
        _frame.DstAddress = this.remoteAddress_;
        _frame.RSequenceNr = this.RSN;
        _frame.SSequenceNr = this.SSN;
        _frame.PollFinal = true;
        this.sendReceiveBytes(_frame.getPDUByteStream());
    }

    public byte[] sendReceive(byte[] outData) throws EzHdlcException, IOException {
        TrialWatch.CheckTimeover();
        TrialWatch.CheckTransactionCount();
        Frame _outFrame = null;
        Frame _inFrame = new Frame();
        Frame _retryFrame = null;
        int _retryCount = 0;
        byte[] _response = null;
        ByteArrayOutputStream _inStream = new ByteArrayOutputStream();
        int _sentQty = 0;
        boolean _remoteReady = true;
        boolean _done = false;
        do {
            if (_remoteReady) {
                if (_retryFrame != null) {
                    if (++_retryCount > 5) {
                        this.throwHDLCException("Max retry reached");
                    } else {
                        _response = this.sendReceiveBytes(_retryFrame.getPDUByteStream());
                        _retryFrame = null;
                    }
                } else if (_sentQty < outData.length) {
                    _outFrame = new Frame(Frame.FrameKind.I, this.localAddress_, this.remoteAddress_, this.RSN, this.SSN);
                    ByteArrayOutputStream _outFrameData = new ByteArrayOutputStream();
                    if (_sentQty == 0) {
                        _outFrameData.write(this.LLCRequestPrefix, 0, this.LLCRequestPrefix.length);
                    }
                    while (_sentQty < outData.length && _outFrameData.size() < this.maxInfoFieldLengthTransmit_) {
                        _outFrameData.write(outData[_sentQty++]);
                    }
                    _outFrame.Segmented = outData.length - _sentQty > 0;
                    this.SSN = (byte)((this.SSN + 1) % 8);
                    _outFrame.Data = _outFrameData.toByteArray();
                    _response = this.sendReceiveBytes(_outFrame.getPDUByteStream());
                } else {
                    _outFrame = new Frame(Frame.FrameKind.RR, this.localAddress_, this.remoteAddress_, this.RSN, this.SSN);
                    _response = this.sendReceiveBytes(_outFrame.getPDUByteStream());
                }
            } else {
                _outFrame = new Frame(Frame.FrameKind.RR, this.localAddress_, this.remoteAddress_, this.RSN, this.SSN);
                _response = this.sendReceiveBytes(_outFrame.getPDUByteStream());
            }
            try {
                if (_response.length == 0) {
                    _retryFrame = new Frame(Frame.FrameKind.RR, this.localAddress_, this.remoteAddress_, this.RSN, this.SSN);
                    continue;
                }
                _inFrame.setFromPduByteStr(_response);
                switch (_inFrame.Kind) {
                    case I: {
                        if (_sentQty < outData.length) {
                            this.throwHDLCException("unexpected I frame");
                        }
                        if (_inFrame.SSequenceNr != this.RSN) {
                            this.throwHDLCException("IS synch lost");
                        }
                        if (_inFrame.RSequenceNr != this.SSN) {
                            this.throwHDLCException("IR synch lost");
                        }
                        this.RSN = (byte)((this.RSN + 1) % 8);
                        _inStream.write(_inFrame.Data, 0, _inFrame.Data.length);
                        _done = !_inFrame.Segmented;
                        break;
                    }
                    case RR: {
                        if (_inFrame.RSequenceNr != this.SSN) {
                            if (_inFrame.RSequenceNr == _outFrame.SSequenceNr) {
                                _retryFrame = _outFrame;
                            } else {
                                this.throwHDLCException("RR synch lost");
                            }
                        }
                        _remoteReady = true;
                        break;
                    }
                    case RNR: {
                        if (_inFrame.RSequenceNr != this.SSN) {
                            this.throwHDLCException("RNR synch lost");
                        }
                        _remoteReady = false;
                        break;
                    }
                    default: {
                        this.throwHDLCException("Unexpected frame kind");
                    }
                }
                if (_retryFrame != null) continue;
                _retryCount = 0;
            }
            catch (EzHdlcException e) {
                if (e.kind == EzHdlcException.EzHdlcExceptionKind.Frame) {
                    _retryFrame = new Frame(Frame.FrameKind.RR, this.localAddress_, this.remoteAddress_, this.RSN, this.SSN);
                    continue;
                }
                throw e;
            }
        } while (!_done);
        byte[] _inData = _inStream.toByteArray();
        if (_inData.length < 3 || _inData[0] != this.LLCResponsePrefix[0] || _inData[1] != this.LLCResponsePrefix[1] || _inData[2] != this.LLCResponsePrefix[2]) {
            this.throwHDLCException("LLC prefix missing in Response");
        }
        ByteArrayOutputStream _data = new ByteArrayOutputStream();
        _data.write(_inData, 3, _inData.length - 3);
        _response = _data.toByteArray();
        return _response;
    }

    private byte[] sendReceiveBytes(byte[] bytesToSend) throws EzHdlcException, IOException {
        boolean _timeout = false;
        int _expectedSize = Integer.MAX_VALUE;
        ByteArrayOutputStream _bytesReceived = new ByteArrayOutputStream();
        try {
            if (this.callbacks_ != null) {
                this.callbacks_.onSentStream(bytesToSend);
            }
            this.outStream_.write(bytesToSend);
            while (!_timeout && _bytesReceived.size() < _expectedSize) {
                int _b = this.inStream_.read();
                _bytesReceived.write(_b);
                boolean bl = _timeout = _b == -1;
                if (!_timeout) {
                    if (_bytesReceived.size() != 3) continue;
                    byte[] _header = _bytesReceived.toByteArray();
                    _expectedSize = (_header[1] & 7) * 256 + (_header[2] & 0xFF) + 2;
                    continue;
                }
                _bytesReceived.reset();
            }
        }
        catch (SocketTimeoutException e) {
            _bytesReceived.reset();
        }
        if (this.callbacks_ != null && _bytesReceived.size() != 0) {
            this.callbacks_.onReceivedStream(_bytesReceived.toByteArray());
        }
        return _bytesReceived.toByteArray();
    }

    private Frame getPushedUIFrame() throws IOException {
        boolean _timeout = false;
        int _expectedSize = Integer.MAX_VALUE;
        ByteArrayOutputStream _bytesReceived = null;
        ByteArrayOutputStream _bytesUIframe = null;
        do {
            try {
                int _b;
                if (this.callbacks_ != null && _bytesReceived != null && _bytesReceived.size() != 0) {
                    this.callbacks_.onReceivedStream(_bytesReceived.toByteArray());
                }
                _bytesReceived = new ByteArrayOutputStream();
                _bytesUIframe = new ByteArrayOutputStream();
                do {
                    boolean bl = _timeout = (_b = this.inStream_.read()) == -1;
                } while (!_timeout && _b != 126);
                _bytesReceived.write(_b);
                if (_timeout) continue;
                _b = this.inStream_.read();
                _bytesReceived.write(_b);
                boolean bl = _timeout = _b == -1;
                if (_timeout || (_b & 0xFFFFFFF0) != -96) continue;
                _expectedSize = Integer.MAX_VALUE;
                while (!_timeout && _bytesReceived.size() < _expectedSize) {
                    _b = this.inStream_.read();
                    _bytesReceived.write(_b);
                    boolean bl2 = _timeout = _b == -1;
                    if (!_timeout) {
                        if (_bytesReceived.size() != 3) continue;
                        byte[] _header = _bytesReceived.toByteArray();
                        _expectedSize = (_header[1] & 7) * 256 + (_header[2] & 0xFF) + 2;
                        continue;
                    }
                    break;
                }
            }
            catch (SocketTimeoutException e) {
                _timeout = true;
            }
            if (this.callbacks_ != null && _bytesReceived.size() != 0) {
                this.callbacks_.onReceivedStream(_bytesReceived.toByteArray());
            }
            if (_timeout) continue;
            try {
                Frame _frame = new Frame();
                _frame.setFromPduByteStr(_bytesReceived.toByteArray());
                if (_frame.Kind != Frame.FrameKind.UI) continue;
                return _frame;
            }
            catch (EzHdlcException ezHdlcException) {
                // empty catch block
            }
        } while (!_timeout);
        return null;
    }

    private byte[] getGBTPayLoad(byte[] s) {
        int _index;
        int _size;
        block5: {
            int _b;
            block4: {
                _b = s[6];
                if ((_b & 0x80) == 0) break block4;
                switch (_b & 7) {
                    case 1: {
                        _size = s[7];
                        _index = 8;
                        break block5;
                    }
                    case 2: {
                        _size = s[7] * 256 + s[8];
                        _index = 9;
                        break block5;
                    }
                    default: {
                        return null;
                    }
                }
            }
            _size = _b;
            _index = 7;
        }
        ByteArrayOutputStream _s = new ByteArrayOutputStream();
        _s.write(s, _index, _size);
        byte[] _payload = _s.toByteArray();
        return _payload;
    }

    private byte[] getPushedTotalData() throws IOException {
        byte[] _response = null;
        boolean _result = false;
        do {
            byte[] _data;
            Frame _frame;
            if ((_frame = this.getPushedUIFrame()) == null || (_data = _frame.Data).length < 3 || _data[0] != this.LLCResponsePrefix[0] || _data[1] != this.LLCResponsePrefix[1] || _data[2] != this.LLCResponsePrefix[2]) continue;
            ByteArrayOutputStream _s = new ByteArrayOutputStream();
            _s.write(_data, 3, _data.length - 3);
            _response = _s.toByteArray();
            if (_frame.Segmented) continue;
            return _response;
        } while (_result);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getPushedAPDU() throws EzHdlcException, IOException {
        _expectedBlockNr = -1;
        block0: while (true) {
            _response = new ByteArrayOutputStream();
            _inGBT = false;
            while (true) {
                if ((_a = this.getPushedTotalData()) == null) {
                    return null;
                }
                if (_a[0] != -32 && !_inGBT) {
                    return _a;
                }
                if (_a[0] != -32 || _a.length < 7) continue;
                _blockControl = _a[1];
                _lastBlock = (_blockControl & 128) != 0;
                _blockNr = _a[2] * 256 + _a[3];
                _payLoad = this.getGBTPayLoad(_a);
                if (_payLoad == null) continue block0;
                _response.write(_payLoad);
                if (!_inGBT) {
                    _inGBT = true;
                    _expectedBlockNr = 1;
                }
                if (_blockNr == _expectedBlockNr) ** break;
                continue block0;
                ++_expectedBlockNr;
                if (_lastBlock) break block0;
            }
            break;
        }
        return _response.toByteArray();
    }

    private void throwHDLCException(String message) throws EzHdlcException {
        throw new EzHdlcException(message, EzHdlcException.EzHdlcExceptionKind.HDLC);
    }
}

