/*
 * Decompiled with CFR 0.152.
 */
package icube.ezhdlc;

import icube.ezhdlc.EzHdlcException;
import icube.ezhdlc.FrameAddress;
import java.io.ByteArrayOutputStream;

public final class Frame {
    public static final byte HDLCFrameFlag = 126;
    public static final byte FrameTypeMask = -16;
    public static final byte FrameTypeValue = -96;
    private static final byte SegmentationMask = 8;
    private static final byte LengthMask = 7;
    private static final FrameAddress NullFrameAddress = new FrameAddress();
    public FrameKind Kind;
    public boolean Segmented;
    public FrameAddress SrcAddress;
    public FrameAddress DstAddress;
    public byte RSequenceNr;
    public byte SSequenceNr;
    public boolean PollFinal;
    public byte[] Data;
    private static short[] fcsTable_;

    static {
        short[] sArray = new short[256];
        sArray[1] = 4489;
        sArray[2] = 8978;
        sArray[3] = 12955;
        sArray[4] = 17956;
        sArray[5] = 22445;
        sArray[6] = 25910;
        sArray[7] = 29887;
        sArray[8] = -29624;
        sArray[9] = -25151;
        sArray[10] = -20646;
        sArray[11] = -16685;
        sArray[12] = -13716;
        sArray[13] = -9243;
        sArray[14] = -5762;
        sArray[15] = -1801;
        sArray[16] = 4225;
        sArray[17] = 264;
        sArray[18] = 13203;
        sArray[19] = 8730;
        sArray[20] = 22181;
        sArray[21] = 18220;
        sArray[22] = 30135;
        sArray[23] = 25662;
        sArray[24] = -25399;
        sArray[25] = -29376;
        sArray[26] = -16421;
        sArray[27] = -20910;
        sArray[28] = -9491;
        sArray[29] = -13468;
        sArray[30] = -1537;
        sArray[31] = -6026;
        sArray[32] = 8450;
        sArray[33] = 12427;
        sArray[34] = 528;
        sArray[35] = 5017;
        sArray[36] = 26406;
        sArray[37] = 30383;
        sArray[38] = 17460;
        sArray[39] = 21949;
        sArray[40] = -21174;
        sArray[41] = -17213;
        sArray[42] = -29096;
        sArray[43] = -24623;
        sArray[44] = -5266;
        sArray[45] = -1305;
        sArray[46] = -14212;
        sArray[47] = -9739;
        sArray[48] = 12675;
        sArray[49] = 8202;
        sArray[50] = 4753;
        sArray[51] = 792;
        sArray[52] = 30631;
        sArray[53] = 26158;
        sArray[54] = 21685;
        sArray[55] = 17724;
        sArray[56] = -16949;
        sArray[57] = -21438;
        sArray[58] = -24871;
        sArray[59] = -28848;
        sArray[60] = -1041;
        sArray[61] = -5530;
        sArray[62] = -9987;
        sArray[63] = -13964;
        sArray[64] = 16900;
        sArray[65] = 21389;
        sArray[66] = 24854;
        sArray[67] = 28831;
        sArray[68] = 1056;
        sArray[69] = 5545;
        sArray[70] = 10034;
        sArray[71] = 14011;
        sArray[72] = -12724;
        sArray[73] = -8251;
        sArray[74] = -4770;
        sArray[75] = -809;
        sArray[76] = -30616;
        sArray[77] = -26143;
        sArray[78] = -21638;
        sArray[79] = -17677;
        sArray[80] = 21125;
        sArray[81] = 17164;
        sArray[82] = 29079;
        sArray[83] = 24606;
        sArray[84] = 5281;
        sArray[85] = 1320;
        sArray[86] = 14259;
        sArray[87] = 9786;
        sArray[88] = -8499;
        sArray[89] = -12476;
        sArray[90] = -545;
        sArray[91] = -5034;
        sArray[92] = -26391;
        sArray[93] = -30368;
        sArray[94] = -17413;
        sArray[95] = -21902;
        sArray[96] = 25350;
        sArray[97] = 29327;
        sArray[98] = 16404;
        sArray[99] = 20893;
        sArray[100] = 9506;
        sArray[101] = 13483;
        sArray[102] = 1584;
        sArray[103] = 6073;
        sArray[104] = -4274;
        sArray[105] = -313;
        sArray[106] = -13220;
        sArray[107] = -8747;
        sArray[108] = -22166;
        sArray[109] = -18205;
        sArray[110] = -30088;
        sArray[111] = -25615;
        sArray[112] = 29575;
        sArray[113] = 25102;
        sArray[114] = 20629;
        sArray[115] = 16668;
        sArray[116] = 13731;
        sArray[117] = 9258;
        sArray[118] = 5809;
        sArray[119] = 1848;
        sArray[120] = -49;
        sArray[121] = -4538;
        sArray[122] = -8995;
        sArray[123] = -12972;
        sArray[124] = -17941;
        sArray[125] = -22430;
        sArray[126] = -25863;
        sArray[127] = -29840;
        sArray[128] = -31736;
        sArray[129] = -27263;
        sArray[130] = -22758;
        sArray[131] = -18797;
        sArray[132] = -15828;
        sArray[133] = -11355;
        sArray[134] = -7874;
        sArray[135] = -3913;
        sArray[136] = 2112;
        sArray[137] = 6601;
        sArray[138] = 11090;
        sArray[139] = 15067;
        sArray[140] = 20068;
        sArray[141] = 24557;
        sArray[142] = 28022;
        sArray[143] = 31999;
        sArray[144] = -27511;
        sArray[145] = -31488;
        sArray[146] = -18533;
        sArray[147] = -23022;
        sArray[148] = -11603;
        sArray[149] = -15580;
        sArray[150] = -3649;
        sArray[151] = -8138;
        sArray[152] = 6337;
        sArray[153] = 2376;
        sArray[154] = 15315;
        sArray[155] = 10842;
        sArray[156] = 24293;
        sArray[157] = 20332;
        sArray[158] = 32247;
        sArray[159] = 27774;
        sArray[160] = -23286;
        sArray[161] = -19325;
        sArray[162] = -31208;
        sArray[163] = -26735;
        sArray[164] = -7378;
        sArray[165] = -3417;
        sArray[166] = -16324;
        sArray[167] = -11851;
        sArray[168] = 10562;
        sArray[169] = 14539;
        sArray[170] = 2640;
        sArray[171] = 7129;
        sArray[172] = 28518;
        sArray[173] = 32495;
        sArray[174] = 19572;
        sArray[175] = 24061;
        sArray[176] = -19061;
        sArray[177] = -23550;
        sArray[178] = -26983;
        sArray[179] = -30960;
        sArray[180] = -3153;
        sArray[181] = -7642;
        sArray[182] = -12099;
        sArray[183] = -16076;
        sArray[184] = 14787;
        sArray[185] = 10314;
        sArray[186] = 6865;
        sArray[187] = 2904;
        sArray[188] = 32743;
        sArray[189] = 28270;
        sArray[190] = 23797;
        sArray[191] = 19836;
        sArray[192] = -14836;
        sArray[193] = -10363;
        sArray[194] = -6882;
        sArray[195] = -2921;
        sArray[196] = -32728;
        sArray[197] = -28255;
        sArray[198] = -23750;
        sArray[199] = -19789;
        sArray[200] = 19012;
        sArray[201] = 23501;
        sArray[202] = 26966;
        sArray[203] = 30943;
        sArray[204] = 3168;
        sArray[205] = 7657;
        sArray[206] = 12146;
        sArray[207] = 16123;
        sArray[208] = -10611;
        sArray[209] = -14588;
        sArray[210] = -2657;
        sArray[211] = -7146;
        sArray[212] = -28503;
        sArray[213] = -32480;
        sArray[214] = -19525;
        sArray[215] = -24014;
        sArray[216] = 23237;
        sArray[217] = 19276;
        sArray[218] = 31191;
        sArray[219] = 26718;
        sArray[220] = 7393;
        sArray[221] = 3432;
        sArray[222] = 16371;
        sArray[223] = 11898;
        sArray[224] = -6386;
        sArray[225] = -2425;
        sArray[226] = -15332;
        sArray[227] = -10859;
        sArray[228] = -24278;
        sArray[229] = -20317;
        sArray[230] = -32200;
        sArray[231] = -27727;
        sArray[232] = 27462;
        sArray[233] = 31439;
        sArray[234] = 18516;
        sArray[235] = 23005;
        sArray[236] = 11618;
        sArray[237] = 15595;
        sArray[238] = 3696;
        sArray[239] = 8185;
        sArray[240] = -2161;
        sArray[241] = -6650;
        sArray[242] = -11107;
        sArray[243] = -15084;
        sArray[244] = -20053;
        sArray[245] = -24542;
        sArray[246] = -27975;
        sArray[247] = -31952;
        sArray[248] = 31687;
        sArray[249] = 27214;
        sArray[250] = 22741;
        sArray[251] = 18780;
        sArray[252] = 15843;
        sArray[253] = 11370;
        sArray[254] = 7921;
        sArray[255] = 3960;
        fcsTable_ = sArray;
    }

    private static short getChecksum(byte[] buffer, int pos, int size) {
        int _result = 65535;
        int i = 0;
        while (i < size) {
            byte n = buffer[pos + i];
            _result = (short)(_result >> 8 ^ fcsTable_[(_result ^ n) & 0xFF]);
            _result &= 0xFFFF;
            ++i;
        }
        _result ^= 0xFFFF;
        _result = (short)((_result << 8) + (_result >> 8));
        short _checksum = (short)_result;
        return _checksum;
    }

    static boolean odd(int x) {
        return (x & 1) != 0;
    }

    static FrameAddress frameBytesToFrameAddress(byte[] pduBytes, int index) {
        FrameAddress _result = new FrameAddress();
        _result.Size = 1;
        while (!Frame.odd(pduBytes[index + _result.Size - 1])) {
            ++_result.Size;
        }
        _result.Upper = 0;
        _result.Lower = 0;
        switch (_result.Size) {
            case 1: {
                _result.Upper = (short)(pduBytes[index] >> 1);
                break;
            }
            case 2: {
                _result.Upper = (short)(pduBytes[index] >> 1);
                _result.Lower = (short)(pduBytes[index + 1] >> 1);
                break;
            }
            case 4: {
                _result.Upper = (short)(pduBytes[index] >> 1 << 7 | pduBytes[index + 1] >> 1);
                _result.Lower = (short)(pduBytes[index + 2] >> 1 << 7 | pduBytes[index + 3] >> 1);
            }
        }
        index += _result.Size;
        return _result;
    }

    static byte[] frameAddressToByteStr(FrameAddress _frameAddress) {
        byte[] _result = null;
        switch (_frameAddress.Size) {
            case 1: {
                _result = new byte[]{(byte)(_frameAddress.Upper << 1 | 1)};
                break;
            }
            case 2: {
                _result = new byte[]{(byte)(_frameAddress.Upper << 1), (byte)(_frameAddress.Lower << 1 | 1)};
                break;
            }
            case 4: {
                _result = new byte[]{(byte)(_frameAddress.Upper >> 7 << 1), (byte)((_frameAddress.Upper & 0x7F) << 1), (byte)(_frameAddress.Lower >> 7 << 1), (byte)((_frameAddress.Lower & 0x7F) << 1 | 1)};
                break;
            }
        }
        return _result;
    }

    public Frame() {
        this(FrameKind.Unknown, NullFrameAddress, NullFrameAddress, 0, 0);
    }

    public Frame(FrameKind kind, FrameAddress srcAddress, FrameAddress dstAddress, byte RSN, byte SSN) {
        this.Kind = kind;
        this.Segmented = false;
        this.SrcAddress = srcAddress;
        this.DstAddress = dstAddress;
        this.RSequenceNr = RSN;
        this.SSequenceNr = SSN;
        this.PollFinal = true;
        this.Data = null;
    }

    public String toString() {
        String _res = String.format("Frame(%s->%s, %s-%s, %d:%d, %s)", new Object[]{this.SrcAddress, this.DstAddress, this.Kind, this.Segmented, this.RSequenceNr, this.SSequenceNr, this.PollFinal});
        return _res;
    }

    public void setFromPduByteStr(byte[] pduBytes) throws EzHdlcException {
        byte _control;
        if (pduBytes.length < 3) {
            this.throwFrameException("Illegal length " + pduBytes.length);
        }
        if (pduBytes[0] != 126) {
            this.throwFrameException("Illegal opening flag");
        }
        if ((pduBytes[1] & 0xFFFFFFF0) != -96) {
            this.throwFrameException("Illegal frame type");
        }
        this.Segmented = (pduBytes[1] & 8) == 8;
        int _length = (pduBytes[1] & 7) * 256 + (pduBytes[2] & 0xFF);
        if (_length != pduBytes.length - 2) {
            this.throwFrameException("Illegal length " + Integer.toString(_length));
        }
        int _index = 3;
        this.DstAddress = Frame.frameBytesToFrameAddress(pduBytes, _index);
        this.SrcAddress = Frame.frameBytesToFrameAddress(pduBytes, _index += this.DstAddress.Size);
        _index += this.SrcAddress.Size;
        if (((_control = pduBytes[_index++]) & 1) == 0) {
            this.Kind = FrameKind.I;
            this.SSequenceNr = (byte)(_control >> 1 & 7);
            this.RSequenceNr = (byte)(_control >> 5 & 7);
        } else {
            block0 : switch (_control & 0xF) {
                case 1: {
                    this.Kind = FrameKind.RR;
                    this.RSequenceNr = (byte)(_control >> 5 & 7);
                    break;
                }
                case 5: {
                    this.Kind = FrameKind.RNR;
                    this.RSequenceNr = (byte)(_control >> 5 & 7);
                    break;
                }
                default: {
                    switch (_control & 0xEF) {
                        case 131: {
                            this.Kind = FrameKind.SNRM;
                            break block0;
                        }
                        case 67: {
                            this.Kind = FrameKind.DISC;
                            break block0;
                        }
                        case 99: {
                            this.Kind = FrameKind.UA;
                            break block0;
                        }
                        case 15: {
                            this.Kind = FrameKind.DM;
                            break block0;
                        }
                        case 135: {
                            this.Kind = FrameKind.FRMR;
                            break block0;
                        }
                        case 3: {
                            this.Kind = FrameKind.UI;
                            break block0;
                        }
                    }
                    this.throwFrameException("Illegal frame kind");
                }
            }
        }
        this.PollFinal = (_control & 0x10) != 0;
        short _computedHCS = Frame.getChecksum(pduBytes, 1, _index - 1);
        short _frameHCS = (short)(pduBytes[_index] << 8 | pduBytes[_index + 1] & 0xFF);
        if (_computedHCS != _frameHCS) {
            this.throwFrameException("Illegal HCS");
        }
        if (pduBytes.length > (_index += 2) + 2) {
            ByteArrayOutputStream _byteStream = new ByteArrayOutputStream();
            _byteStream.write(pduBytes, _index, pduBytes.length - _index - 3);
            this.Data = _byteStream.toByteArray();
            _computedHCS = Frame.getChecksum(pduBytes, 1, pduBytes.length - 4);
            _frameHCS = (short)(pduBytes[_index += _byteStream.size()] << 8 | pduBytes[_index + 1] & 0xFF);
            if (_computedHCS != _frameHCS) {
                this.throwFrameException("Illegal FCS");
            }
            _index += 2;
        } else {
            this.Data = null;
        }
        if (pduBytes[_index] != 126) {
            this.throwFrameException("Illegal closing flag");
        }
    }

    public byte[] getPDUByteStream() {
        ByteArrayOutputStream _result = new ByteArrayOutputStream();
        byte[] _srcAddrStr = null;
        byte[] _dstAddrStr = null;
        int _control = 0;
        _result.write(126);
        _srcAddrStr = Frame.frameAddressToByteStr(this.SrcAddress);
        _dstAddrStr = Frame.frameAddressToByteStr(this.DstAddress);
        int _formatField = -24576;
        if (this.Segmented) {
            _formatField = (short)(_formatField + 2048);
        }
        _formatField = this.Data != null ? (int)((short)(_formatField | (short)(_srcAddrStr.length + _dstAddrStr.length + this.Data.length + 7 & 0x7FF))) : (int)((short)(_formatField | (short)(_srcAddrStr.length + _dstAddrStr.length + 5 & 0x7FF)));
        switch (this.Kind) {
            case I: {
                _control = (byte)((this.RSequenceNr << 5) + (this.SSequenceNr << 1));
                break;
            }
            case RR: {
                _control = (byte)((this.RSequenceNr << 5) + 1);
                break;
            }
            case RNR: {
                _control = (byte)((this.RSequenceNr << 5) + 5);
                break;
            }
            case SNRM: {
                _control = -125;
                break;
            }
            case DISC: {
                _control = 67;
                break;
            }
            case UA: {
                _control = 99;
                break;
            }
            case DM: {
                _control = 15;
                break;
            }
            case FRMR: {
                _control = -121;
                break;
            }
            case UI: {
                _control = 3;
            }
        }
        if (this.PollFinal) {
            _control = (byte)(_control | 0x10);
        }
        _result.write((byte)(_formatField >> 8));
        _result.write((byte)(_formatField & 0xFF));
        _result.write(_dstAddrStr, 0, _dstAddrStr.length);
        _result.write(_srcAddrStr, 0, _srcAddrStr.length);
        _result.write(_control);
        short w = Frame.getChecksum(_result.toByteArray(), 1, _result.size() - 1);
        _result.write((byte)(w >> 8));
        _result.write((byte)(w & 0xFF));
        if (this.Data != null) {
            _result.write(this.Data, 0, this.Data.length);
            w = Frame.getChecksum(_result.toByteArray(), 1, _result.size() - 1);
            _result.write((byte)(w >> 8));
            _result.write((byte)(w & 0xFF));
        }
        _result.write(126);
        return _result.toByteArray();
    }

    private void throwFrameException(String message) throws EzHdlcException {
        throw new EzHdlcException(message, EzHdlcException.EzHdlcExceptionKind.Frame);
    }

    public static enum FrameKind {
        Unknown,
        I,
        RNR,
        RR,
        DISC,
        DM,
        FRMR,
        SNRM,
        UA,
        UI;

    }
}

