/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortDataListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortMessageListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class SerialPort {
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_READ_BLOCKING = 16;
    public static final int TIMEOUT_WRITE_BLOCKING = 256;
    public static final int TIMEOUT_SCANNER = 4096;
    public static final int LISTENING_EVENT_TIMED_OUT = 0;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    public static final int LISTENING_EVENT_BREAK_INTERRUPT = 65536;
    public static final int LISTENING_EVENT_CARRIER_DETECT = 131072;
    public static final int LISTENING_EVENT_CTS = 262144;
    public static final int LISTENING_EVENT_DSR = 524288;
    public static final int LISTENING_EVENT_RING_INDICATOR = 0x100000;
    public static final int LISTENING_EVENT_FRAMING_ERROR = 0x200000;
    public static final int LISTENING_EVENT_FIRMWARE_OVERRUN_ERROR = 0x400000;
    public static final int LISTENING_EVENT_SOFTWARE_OVERRUN_ERROR = 0x800000;
    public static final int LISTENING_EVENT_PARITY_ERROR = 0x1000000;
    public static final int LISTENING_EVENT_PORT_DISCONNECTED = 0x10000000;
    private static final String versionString = "2.9.2";
    private static final String tmpdirAppIdProperty = "fazecast.jSerialComm.appid";
    private static final List<Thread> shutdownHooks = new ArrayList<Thread>();
    private static boolean isWindows = false;
    private static boolean isAndroid = false;
    private static volatile boolean isShuttingDown = false;
    private volatile long portHandle = 0L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile int sendDeviceQueueSize = 4096;
    private volatile int receiveDeviceQueueSize = 4096;
    private volatile int safetySleepTimeMS = 200;
    private volatile int rs485DelayBefore = 0;
    private volatile int rs485DelayAfter = 0;
    private volatile byte xonStartChar = (byte)17;
    private volatile byte xoffStopChar = (byte)19;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String comPort;
    private volatile String friendlyName;
    private volatile String portDescription;
    private volatile String portLocation;
    private volatile boolean eventListenerRunning = false;
    private volatile boolean disableConfig = false;
    private volatile boolean disableExclusiveLock = false;
    private volatile boolean rs485Mode = false;
    private volatile boolean rs485ActiveHigh = true;
    private volatile boolean rs485RxDuringTx = false;
    private volatile boolean rs485EnableTermination = false;
    private volatile boolean isRtsEnabled = true;
    private volatile boolean isDtrEnabled = true;
    private volatile boolean autoFlushIOBuffers = false;
    private volatile boolean requestElevatedPermissions = false;

    private static boolean isSymbolicLink(File file) throws IOException {
        File canonicalFile = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
    }

    private static void cleanUpDirectory(File path) {
        File[] files;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().equals(versionString)) continue;
                SerialPort.cleanUpDirectory(file);
            }
        }
        if (!path.getName().equals(versionString)) {
            path.delete();
        }
    }

    private static boolean loadNativeLibrary(String absoluteLibraryPath, Vector<String> errorMessages) {
        try {
            System.load(absoluteLibraryPath);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errorMessages.add(e.getMessage());
            return false;
        }
        catch (Exception e) {
            errorMessages.add(e.getMessage());
            return false;
        }
    }

    public final String toString() {
        return this.getPortDescription();
    }

    public static String getVersion() {
        return versionString;
    }

    public static synchronized void addShutdownHook(Thread hook) {
        shutdownHooks.add(hook);
    }

    public static synchronized SerialPort[] getCommPorts() {
        return SerialPort.getCommPortsNative();
    }

    public static synchronized SerialPort getCommPort(String portDescriptor) throws SerialPortInvalidPortException {
        try {
            if (portDescriptor.startsWith("~" + File.separator)) {
                portDescriptor = System.getProperty("user.home") + portDescriptor.substring(1);
            }
            if (isWindows) {
                portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(portDescriptor))) {
                portDescriptor = new File(portDescriptor).getCanonicalPath();
            } else if (!new File(portDescriptor).exists()) {
                portDescriptor = "/dev/" + portDescriptor;
                if (!new File(portDescriptor).exists()) {
                    portDescriptor = "/dev/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
                }
                if (!new File(portDescriptor).exists()) {
                    throw new IOException();
                }
            }
        }
        catch (Exception e) {
            throw new SerialPortInvalidPortException("Unable to create a serial port object from the invalid port descriptor: " + portDescriptor, e);
        }
        SerialPort serialPort = new SerialPort();
        serialPort.comPort = portDescriptor;
        serialPort.friendlyName = "User-Specified Port";
        serialPort.portDescription = "User-Specified Port";
        serialPort.portLocation = "0-0";
        serialPort.retrievePortDetails();
        return serialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean openPort(int safetySleepTime, int deviceSendQueueSize, int deviceReceiveQueueSize) {
        File portFile;
        this.safetySleepTimeMS = safetySleepTime;
        this.sendDeviceQueueSize = deviceSendQueueSize > 0 ? deviceSendQueueSize : this.sendDeviceQueueSize;
        int n = this.receiveDeviceQueueSize = deviceReceiveQueueSize > 0 ? deviceReceiveQueueSize : this.receiveDeviceQueueSize;
        if (this.portHandle != 0L) {
            return this.configPort(this.portHandle);
        }
        if (this.safetySleepTimeMS > 0) {
            try {
                Thread.sleep(this.safetySleepTimeMS);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        File file = portFile = isAndroid ? new File(this.comPort) : null;
        if (!(portFile == null || portFile.canRead() && portFile.canWrite())) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec("su");
                DataOutputStream writer = new DataOutputStream(process.getOutputStream());
                writer.writeBytes("chmod 666 " + this.comPort + "\n");
                writer.writeBytes("exit\n");
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (reader.readLine() != null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (process == null) {
                    return false;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        this.portHandle = this.openPortNative();
        if (this.portHandle != 0L && this.serialEventListener != null) {
            this.serialEventListener.startListening();
        }
        return this.portHandle != 0L;
    }

    public final synchronized boolean openPort(int safetySleepTime) {
        return this.openPort(safetySleepTime, this.sendDeviceQueueSize, this.receiveDeviceQueueSize);
    }

    public final synchronized boolean openPort() {
        return this.openPort(0);
    }

    public final synchronized boolean closePort() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
        }
        if (this.portHandle != 0L) {
            this.portHandle = this.closePortNative(this.portHandle);
        }
        return this.portHandle == 0L;
    }

    public final synchronized boolean isOpen() {
        return this.portHandle != 0L;
    }

    public final synchronized void disablePortConfiguration() {
        this.disableConfig = true;
    }

    public final synchronized void disableExclusiveLock() {
        this.disableExclusiveLock = true;
    }

    public final synchronized void allowElevatedPermissionsRequest() {
        this.requestElevatedPermissions = true;
    }

    public final synchronized int getLastErrorLocation() {
        return this.getLastErrorLocation(this.portHandle);
    }

    public final synchronized int getLastErrorCode() {
        return this.getLastErrorCode(this.portHandle);
    }

    private static native void uninitializeLibrary();

    private static native SerialPort[] getCommPortsNative();

    private native void retrievePortDetails();

    private native long openPortNative();

    private native long closePortNative(long var1);

    private native boolean configPort(long var1);

    private native boolean configTimeouts(long var1, int var3, int var4, int var5, int var6);

    private native boolean flushRxTxBuffers(long var1);

    private native int waitForEvent(long var1);

    private native int bytesAvailable(long var1);

    private native int bytesAwaitingWrite(long var1);

    private native int readBytes(long var1, byte[] var3, long var4, long var6, int var8, int var9);

    private native int writeBytes(long var1, byte[] var3, long var4, long var6, int var8);

    private native void setEventListeningStatus(long var1, boolean var3);

    private native boolean setBreak(long var1);

    private native boolean clearBreak(long var1);

    private native boolean setRTS(long var1);

    private native boolean clearRTS(long var1);

    private native boolean presetRTS();

    private native boolean preclearRTS();

    private native boolean setDTR(long var1);

    private native boolean clearDTR(long var1);

    private native boolean presetDTR();

    private native boolean preclearDTR();

    private native boolean getCTS(long var1);

    private native boolean getDSR(long var1);

    private native boolean getDCD(long var1);

    private native boolean getDTR(long var1);

    private native boolean getRTS(long var1);

    private native boolean getRI(long var1);

    private native int getLastErrorLocation(long var1);

    private native int getLastErrorCode(long var1);

    public final int bytesAvailable() {
        return this.portHandle != 0L ? this.bytesAvailable(this.portHandle) : -1;
    }

    public final int bytesAwaitingWrite() {
        return this.portHandle != 0L ? this.bytesAwaitingWrite(this.portHandle) : -1;
    }

    public final int readBytes(byte[] buffer, long bytesToRead) {
        return this.portHandle != 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, 0L, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int readBytes(byte[] buffer, long bytesToRead, long offset) {
        return this.portHandle != 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, offset, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite) {
        int numWritten;
        int totalNumWritten = 0;
        while (this.portHandle != 0L && (long)totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - (long)totalNumWritten, totalNumWritten, this.timeoutMode)) > 0) {
            totalNumWritten += numWritten;
        }
        return this.portHandle != 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite, long offset) {
        int numWritten;
        int totalNumWritten = 0;
        while (this.portHandle != 0L && (long)totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - (long)totalNumWritten, offset + (long)totalNumWritten, this.timeoutMode)) > 0) {
            totalNumWritten += numWritten;
        }
        return this.portHandle != 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int getDeviceWriteBufferSize() {
        return this.sendDeviceQueueSize;
    }

    public final int getDeviceReadBufferSize() {
        return this.receiveDeviceQueueSize;
    }

    public final boolean setBreak() {
        return this.portHandle != 0L && this.setBreak(this.portHandle);
    }

    public final boolean clearBreak() {
        return this.portHandle != 0L && this.clearBreak(this.portHandle);
    }

    public final boolean setRTS() {
        this.isRtsEnabled = true;
        return this.portHandle != 0L ? this.setRTS(this.portHandle) : this.presetRTS();
    }

    public final boolean clearRTS() {
        this.isRtsEnabled = false;
        return this.portHandle != 0L ? this.clearRTS(this.portHandle) : this.preclearRTS();
    }

    public final boolean setDTR() {
        this.isDtrEnabled = true;
        return this.portHandle != 0L ? this.setDTR(this.portHandle) : this.presetDTR();
    }

    public final boolean clearDTR() {
        this.isDtrEnabled = false;
        return this.portHandle != 0L ? this.clearDTR(this.portHandle) : this.preclearDTR();
    }

    public final boolean getCTS() {
        return this.portHandle != 0L && this.getCTS(this.portHandle);
    }

    public final boolean getDSR() {
        return this.portHandle != 0L && this.getDSR(this.portHandle);
    }

    public final boolean getDCD() {
        return this.portHandle != 0L && this.getDCD(this.portHandle);
    }

    public final boolean getDTR() {
        return this.portHandle != 0L && this.getDTR(this.portHandle);
    }

    public final boolean getRTS() {
        return this.portHandle != 0L && this.getRTS(this.portHandle);
    }

    public final boolean getRI() {
        return this.portHandle != 0L && this.getRI(this.portHandle);
    }

    private SerialPort() {
    }

    public final synchronized boolean addDataListener(SerialPortDataListener listener) {
        if (this.userDataListener != null) {
            return false;
        }
        this.userDataListener = listener;
        this.eventFlags = listener.getListeningEvents();
        if ((this.eventFlags & 0x10) > 0) {
            this.eventFlags |= 1;
        }
        SerialPortEventListener serialPortEventListener = this.userDataListener instanceof SerialPortPacketListener ? new SerialPortEventListener(((SerialPortPacketListener)this.userDataListener).getPacketSize()) : (this.serialEventListener = this.userDataListener instanceof SerialPortMessageListener ? new SerialPortEventListener(((SerialPortMessageListener)this.userDataListener).getMessageDelimiter(), ((SerialPortMessageListener)this.userDataListener).delimiterIndicatesEndOfMessage()) : new SerialPortEventListener());
        if (this.portHandle != 0L) {
            this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
            this.serialEventListener.startListening();
        }
        return true;
    }

    public final synchronized void removeDataListener() {
        this.eventFlags = 0;
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
            this.serialEventListener = null;
            if (this.portHandle != 0L) {
                this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
            }
        }
        this.userDataListener = null;
    }

    public final InputStream getInputStream() {
        return new SerialPortInputStream(false);
    }

    public final InputStream getInputStreamWithSuppressedTimeoutExceptions() {
        return new SerialPortInputStream(true);
    }

    public final OutputStream getOutputStream() {
        return new SerialPortOutputStream();
    }

    public final synchronized boolean flushIOBuffers() {
        this.autoFlushIOBuffers = true;
        if (this.portHandle != 0L) {
            return this.flushRxTxBuffers(this.portHandle);
        }
        return true;
    }

    public final boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        return this.setComPortParameters(newBaudRate, newDataBits, newStopBits, newParity, this.rs485Mode);
    }

    public final synchronized boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity, boolean useRS485Mode) {
        this.baudRate = newBaudRate;
        this.dataBits = newDataBits;
        this.stopBits = newStopBits;
        this.parity = newParity;
        this.rs485Mode = useRS485Mode;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        this.timeoutMode = newTimeoutMode;
        if (isWindows) {
            this.readTimeout = newReadTimeout;
            this.writeTimeout = newWriteTimeout;
        } else {
            this.readTimeout = newReadTimeout > 0 && newReadTimeout <= 100 ? 100 : Math.round((float)newReadTimeout / 100.0f) * 100;
        }
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
        }
        return true;
    }

    public final synchronized boolean setBaudRate(int newBaudRate) {
        this.baudRate = newBaudRate;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setNumDataBits(int newDataBits) {
        this.dataBits = newDataBits;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setNumStopBits(int newStopBits) {
        this.stopBits = newStopBits;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setFlowControl(int newFlowControlSettings) {
        this.flowControl = newFlowControlSettings;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setParity(int newParity) {
        this.parity = newParity;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        return this.setRs485ModeParameters(useRS485Mode, rs485RtsActiveHigh, false, false, delayBeforeSendMicroseconds, delayAfterSendMicroseconds);
    }

    public final synchronized boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, boolean enableTermination, boolean rxDuringTx, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        this.rs485Mode = useRS485Mode;
        this.rs485ActiveHigh = rs485RtsActiveHigh;
        this.rs485EnableTermination = enableTermination;
        this.rs485RxDuringTx = rxDuringTx;
        this.rs485DelayBefore = delayBeforeSendMicroseconds;
        this.rs485DelayAfter = delayAfterSendMicroseconds;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setXonXoffCharacters(byte xonStartCharacter, byte xoffStopCharacter) {
        this.xonStartChar = xonStartCharacter;
        this.xoffStopChar = xoffStopCharacter;
        if (this.portHandle != 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final String getDescriptivePortName() {
        return this.friendlyName.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final String getSystemPortPath() {
        return this.comPort;
    }

    public final String getPortDescription() {
        return this.portDescription.trim();
    }

    public final String getPortLocation() {
        return this.portLocation;
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        String[] architectures = null;
        String libraryPath = "";
        String libraryFileName = "";
        String OS = System.getProperty("os.name").toLowerCase();
        String manualLibraryPath = System.getProperty("jSerialComm.library.path", "");
        String tempFileDirectory = System.getProperty("java.io.tmpdir");
        String userHomeDirectory = System.getProperty("user.home");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + File.separator;
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + File.separator;
        }
        if (!(manualLibraryPath.isEmpty() || manualLibraryPath.endsWith("\\") || manualLibraryPath.endsWith("/"))) {
            manualLibraryPath = manualLibraryPath + File.separator;
        }
        tempFileDirectory = tempFileDirectory + "jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, "");
        userHomeDirectory = userHomeDirectory + ".jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, "");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + File.separator;
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + File.separator;
        }
        SerialPort.cleanUpDirectory(new File(tempFileDirectory));
        SerialPort.cleanUpDirectory(new File(userHomeDirectory));
        tempFileDirectory = tempFileDirectory + versionString + File.separator;
        userHomeDirectory = userHomeDirectory + versionString + File.separator;
        if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
            isAndroid = true;
            libraryPath = "Android";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"arm64-v8a", "armeabi-v7a", "x86_64", "x86"};
        } else if (OS.contains("win")) {
            isWindows = true;
            libraryPath = "Windows";
            libraryFileName = "jSerialComm.dll";
            architectures = new String[]{"aarch64", "armv7", "x86_64", "x86"};
        } else if (OS.contains("mac")) {
            libraryPath = "OSX";
            libraryFileName = "libjSerialComm.jnilib";
            architectures = new String[]{"aarch64", "x86_64", "x86"};
        } else if (OS.contains("sunos") || OS.contains("solaris")) {
            libraryPath = "Solaris";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"sparcv9_64", "sparcv8plus_32", "x86_64", "x86"};
        } else if (OS.contains("freebsd")) {
            libraryPath = "FreeBSD";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"arm64", "x86_64", "x86"};
        } else if (OS.contains("openbsd")) {
            libraryPath = "OpenBSD";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"amd64", "x86"};
        } else if (OS.contains("nix") || OS.contains("nux")) {
            libraryPath = "Linux";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"armv8_64", "x86_64", "armv8_32", "armv7hf", "armv7", "armv6hf", "armv6", "armv5", "ppc64le", "x86"};
        } else {
            System.err.println("This operating system is not supported by the jSerialComm library.");
            System.exit(-1);
        }
        boolean libraryLoaded = false;
        Vector<String> errorMessages = new Vector<String>();
        if (!manualLibraryPath.isEmpty()) {
            for (int i = 0; !libraryLoaded && i < architectures.length; ++i) {
                libraryLoaded = SerialPort.loadNativeLibrary(new File(manualLibraryPath + libraryPath + File.separator + architectures[i] + File.separator + libraryFileName).getAbsolutePath(), errorMessages);
            }
            if (!libraryLoaded) {
                libraryLoaded = SerialPort.loadNativeLibrary(new File(manualLibraryPath + libraryFileName).getAbsolutePath(), errorMessages);
            }
        }
        for (int attempt = 0; !libraryLoaded && attempt < 2; ++attempt) {
            File nativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + libraryFileName);
            libraryLoaded = nativeLibrary.exists() && SerialPort.loadNativeLibrary(nativeLibrary.getAbsolutePath(), errorMessages);
        }
        String attempt1Library = "";
        for (int attempt = 0; !libraryLoaded && attempt < 2; ++attempt) {
            File tempNativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + libraryFileName);
            if (attempt == 0) {
                attempt1Library = tempNativeLibrary.getAbsolutePath();
            }
            if (!tempNativeLibrary.getParentFile().exists() && !tempNativeLibrary.getParentFile().mkdirs()) continue;
            tempNativeLibrary.getParentFile().setReadable(true, false);
            tempNativeLibrary.getParentFile().setWritable(true, true);
            tempNativeLibrary.getParentFile().setExecutable(true, false);
            for (int i = 0; !libraryLoaded && i < architectures.length; ++i) {
                InputStream fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + architectures[i] + "/" + libraryFileName);
                if (fileContents == null) continue;
                try {
                    int numBytesRead;
                    tempNativeLibrary.delete();
                    FileOutputStream destinationFileContents = new FileOutputStream(tempNativeLibrary);
                    byte[] transferBuffer = new byte[4096];
                    while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                        destinationFileContents.write(transferBuffer, 0, numBytesRead);
                    }
                    destinationFileContents.close();
                    fileContents.close();
                    tempNativeLibrary.setReadable(true, false);
                    tempNativeLibrary.setWritable(false, false);
                    tempNativeLibrary.setExecutable(true, false);
                    errorMessages.add("Loading for arch: " + architectures[i]);
                    libraryLoaded = SerialPort.loadNativeLibrary(tempNativeLibrary.getAbsolutePath(), errorMessages);
                    if (!libraryLoaded) continue;
                    errorMessages.add("Successfully loaded!");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (libraryLoaded) continue;
            tempNativeLibrary.delete();
            if (attempt <= 0) continue;
            StringBuilder errorMessage = new StringBuilder("Cannot load native library. Errors as follows:\n");
            for (int i = 0; i < errorMessages.size(); ++i) {
                errorMessage.append('[').append(i + 1).append("]: ").append(errorMessages.get(i)).append('\n');
            }
            throw new UnsatisfiedLinkError(errorMessage.toString());
        }
        Runtime.getRuntime().addShutdownHook(SerialPortThreadFactory.get().newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Thread hook : shutdownHooks) {
                        hook.start();
                        hook.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                isShuttingDown = true;
                SerialPort.uninitializeLibrary();
            }
        }));
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        private final byte[] byteBuffer = new byte[1];

        @Override
        public final void write(int b) throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            this.byteBuffer[0] = (byte)(b & 0xFF);
            int bytesWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, this.byteBuffer, 1L, 0L, SerialPort.this.timeoutMode);
            if (bytesWritten < 0) {
                throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
            }
            if (bytesWritten == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }

        @Override
        public final void write(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            int numWritten;
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the write buffer.");
            }
            if (len < 0 || off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException("The specified write offset plus length extends past the end of the specified buffer.");
            }
            for (int totalNumWritten = 0; totalNumWritten != len; totalNumWritten += numWritten) {
                if (SerialPort.this.portHandle == 0L) {
                    throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
                }
                numWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, b, len - totalNumWritten, off + totalNumWritten, SerialPort.this.timeoutMode);
                if (numWritten < 0) {
                    throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
                }
                if (numWritten != 0) continue;
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        private final boolean timeoutExceptionsSuppressed;
        private final byte[] byteBuffer = new byte[1];

        public SerialPortInputStream(boolean suppressReadTimeoutExceptions) {
            this.timeoutExceptionsSuppressed = suppressReadTimeoutExceptions;
        }

        @Override
        public final int available() throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable();
        }

        @Override
        public final int read() throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            int numRead = SerialPort.this.readBytes(this.byteBuffer, 1L);
            if (numRead == 0) {
                if (this.timeoutExceptionsSuppressed) {
                    return -1;
                }
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead < 0 ? -1 : this.byteBuffer[0] & 0xFF;
        }

        @Override
        public final int read(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(b, b.length);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final int read(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (len < 0 || off < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("The specified read offset plus length extends past the end of the specified buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0 || len == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(b, len, off);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[(int)n];
            return SerialPort.this.readBytes(buffer, n);
        }
    }

    private final class SerialPortEventListener {
        private final boolean messageEndIsDelimited;
        private final byte[] dataPacket;
        private final byte[] delimiters;
        private final ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
        private int dataPacketIndex = 0;
        private int delimiterIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener() {
            this.dataPacket = new byte[0];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(byte[] messageDelimiters, boolean delimiterForMessageEnd) {
            this.dataPacket = new byte[0];
            this.delimiters = messageDelimiters;
            this.messageEndIsDelimited = delimiterForMessageEnd;
        }

        public final void startListening() {
            if (SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = true;
            this.dataPacketIndex = 0;
            SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, true);
            this.serialEventThread = SerialPortThreadFactory.get().newThread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPort.this.eventListenerRunning && !isShuttingDown) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (Exception e) {
                            SerialPort.this.eventListenerRunning = false;
                            if (SerialPort.this.userDataListener instanceof SerialPortDataListenerWithExceptions) {
                                ((SerialPortDataListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                                continue;
                            }
                            if (!(SerialPort.this.userDataListener instanceof SerialPortMessageListenerWithExceptions)) continue;
                            ((SerialPortMessageListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                        }
                    }
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = false;
            SerialPort.this.configTimeouts(SerialPort.this.portHandle, 0, 0, 0, 0);
            SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, false);
            try {
                if (!Thread.currentThread().equals(this.serialEventThread)) {
                    do {
                        this.serialEventThread.join(500L);
                        if (!this.serialEventThread.isAlive()) continue;
                        this.serialEventThread.interrupt();
                    } while (this.serialEventThread.isAlive());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.serialEventThread = null;
        }

        public final void waitForSerialEvent() throws Exception {
            int event = SerialPort.this.waitForEvent(SerialPort.this.portHandle) & SerialPort.this.eventFlags;
            if ((event & 1) > 0 && (SerialPort.this.eventFlags & 0x10) > 0) {
                int numBytesAvailable;
                event &= 0xFFFFFFEE;
                while (SerialPort.this.eventListenerRunning && (numBytesAvailable = SerialPort.this.bytesAvailable()) > 0) {
                    int newBytesIndex = 0;
                    byte[] newBytes = new byte[numBytesAvailable];
                    int bytesRemaining = SerialPort.this.readBytes(newBytes, newBytes.length);
                    if (bytesRemaining <= 0) continue;
                    if (this.delimiters.length > 0) {
                        int startIndex = 0;
                        for (int offset = 0; offset < bytesRemaining; ++offset) {
                            if (newBytes[offset] == this.delimiters[this.delimiterIndex]) {
                                byte[] byteArray;
                                if (++this.delimiterIndex != this.delimiters.length) continue;
                                this.messageBytes.write(newBytes, startIndex, 1 + offset - startIndex);
                                byte[] byArray = byteArray = this.messageEndIsDelimited ? this.messageBytes.toByteArray() : Arrays.copyOf(this.messageBytes.toByteArray(), this.messageBytes.size() - this.delimiters.length);
                                if (byteArray.length > 0 && (this.messageEndIsDelimited || this.delimiters[0] == byteArray[0])) {
                                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, byteArray));
                                }
                                startIndex = offset + 1;
                                this.messageBytes.reset();
                                this.delimiterIndex = 0;
                                if (this.messageEndIsDelimited) continue;
                                this.messageBytes.write(this.delimiters, 0, this.delimiters.length);
                                continue;
                            }
                            if (this.delimiterIndex == 0) continue;
                            this.delimiterIndex = newBytes[offset] == this.delimiters[0] ? 1 : 0;
                        }
                        this.messageBytes.write(newBytes, startIndex, bytesRemaining - startIndex);
                        continue;
                    }
                    if (this.dataPacket.length == 0) {
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])newBytes.clone()));
                        continue;
                    }
                    while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                        System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                        bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                        newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                        this.dataPacketIndex = 0;
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                    }
                    if (bytesRemaining <= 0) continue;
                    System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                    this.dataPacketIndex += bytesRemaining;
                }
            }
            if (SerialPort.this.eventListenerRunning && !isShuttingDown && event != 0) {
                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, event));
            }
        }
    }
}

